/* cpu.c - this holds the main loop for the emulator, plus generic
 * functions to deal with exceptional instructions and events
 *
 * $Revision: 1.15 $
 * $Date: 1999/01/06 00:01:11 $
 */
#include "defines.h"

u_int8_t *ispace, *dspace;	/* Instruction and Data spaces */
u_int16_t dwrite_base=2;	/* Lowest addr where dspace writes can occur */

u_int16_t regs[8];		/* general registers */
u_int16_t ir;			/* current instruction register */
u_int16_t *adptr;		/* used in memory access macros */
u_int16_t ea_addr;		/* stored address for dest modifying insts */

int CC_N=0;			/* The processor status word is represented */
int CC_Z=0;			/* by these four values. On some */
int CC_V=0;			/* architectures, you may get a performance */
int CC_C=0;			/* increase by using shorts or bytes */

u_int16_t dstword;		/* These globals are used in the effective */
u_int16_t srcword;		/* address calculations, mainly to save */
u_int16_t tmpword;		/* parameter passing overheads in */
u_int8_t dstbyte;		/* function calls */
u_int8_t srcbyte;
u_int8_t tmpbyte;
#ifdef DEBUG
extern char *iname[1024];
extern char *iname0[64];	/* Name of each instruction */
extern char *iname1[64];
char *name;
#endif


/* Run until told to stop. */
void run() {
#ifdef DEBUG
    int i;
    extern int getpid();

    if (trap_debug) {
	fprintf(dbg_file, "Just starting to run pid %d\n",getpid());
	fprintf(dbg_file, "Regs are ");
	for (i=0;i<=PC;i++) fprintf(dbg_file, "%4o ",regs[i]);
	fprintf(dbg_file, "\n");
    }
#endif

    while (1) {

	/* Fetch and execute the instruction. */

#ifdef DEBUG
	lli_word(regs[PC], ir);
	if (inst_debug) {
	   i= ir >> 6;
	   switch (i) {
		case 0: name= iname0[ir & 077]; break;
		case 2: name= iname1[ir & 077]; break;
		default: name= iname[i];
	   }
	   fprintf(dbg_file, "%06o %06o %s ", regs[7], ir, name);
	   fprintf(dbg_file, "%o %o %o %o %o %o %o   ",
		regs[0], regs[1], regs[2], regs[3],
		regs[4], regs[5], regs[6]);
	   fprintf(dbg_file, "NZVC %d%d%d%d\n",CC_N,CC_Z,CC_V,CC_C);
	}
	regs[PC] += 2; itab[ir >> 6] ();
#else
	/* When not debugging, we can manually unroll this inner loop */
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
#endif
    }
}

/* sim_init() - Initialize the cpu registers. */
void sim_init() {
    int x;

    for (x = 0; x < 8; ++x) { regs[x] = 0; }
    ir = 0; CLR_CC_ALL();
}

void bus_error() {
    fprintf(stderr, "Apout - bus error at PC 0%06o\n", regs[PC]);
    printf("%06o  ", ir);
    printf("%o %o %o %o %o %o %o %o  ",
	 regs[0], regs[1], regs[2], regs[3],
	 regs[4], regs[5], regs[6], regs[7]);
    printf("NZVC are %d%d%d%d\n",CC_N,CC_Z,CC_V,CC_C);
    exit(1);
}

void seg_fault() {
    fprintf(stderr, "Apout - segmentation fault at PC 0%06o\n", regs[PC]);
    printf("%06o  ", ir);
    printf("%o %o %o %o %o %o %o %o  ",
	 regs[0], regs[1], regs[2], regs[3],
	 regs[4], regs[5], regs[6], regs[7]);
    printf("NZVC are %d%d%d%d\n",CC_N,CC_Z,CC_V,CC_C);
    exit(1);
}

void waiti() {
    fprintf(stderr, "Apout - waiti instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void halt() {
    fprintf(stderr, "Apout - halt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void iot() {
    fprintf(stderr, "Apout - iot instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void emt() {
    fprintf(stderr, "Apout - emt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void bpt() {
    fprintf(stderr, "Apout - bpt instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void fis() {
    fprintf(stderr, "Apout - unimplemented float instruction %o at PC 0x%x\n",
							ir, regs[PC]);
    exit(1);
}
void illegal() {
    fprintf(stderr, "Apout - illegal instruction %o at PC 0x%x\n",ir, regs[PC]);
    exit(1);
}
void not_impl() {
    fprintf(stderr, "Apout - unimplemented instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void mark() {
    fprintf(stderr, "Apout - mark instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void mfpd() {
    fprintf(stderr, "Apout - mfpd instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void mtpd() {
    fprintf(stderr, "Apout - mtpd instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void trap() {
    fprintf(stderr, "Apout - trap instruction at PC 0x%x\n", regs[PC]);
    exit(1);
}
void bad_FP_reg() {
    fprintf(stderr, "Apout - bad FP register used at PC 0x%x\n", regs[PC]);
    exit(1);
}
