/*          constants for editor (em)               */


/*              number of open files/process            */

#define NOFILE  20
#define INPFILES        NOFILE-10

/*              standard input and output               */

#define STANDIN 0
#define STANDOUT 1

/*              character and byte mask                 */

#define ASCII   0177
#define BYTE    0377

/*              special characters                      */

#include "ascii.h"
#define EOF     -1
#define SPLIT   '-'
#define PROMPT  '>'
#define CONFIRM '.'
#define SCORE   '^'
#define QUOTE   '"'
#define ERRCHAR '?'
#define BSL     '\\'

/*              buffer sizes                            */

#define MBSIZE  1024
#define FNSIZE  64
#define LBSIZE  512
#define SBSIZE  256
#define FBSIZE  512
#define EBSIZE  128
#define CBSIZE  128
#define GBSIZE  256
#define KSIZE   10
#define KBSIZE  26

/*              encoding of regular expressions         */

#define CBRA    1
#define CCHR    2
#define CDOT    4
#define CCL     6
#define NCCL    8
#define CDOL    10
#define CEOF    11
#define CKET    12
#define CBACK   14
#define STAR    01

/*              number of \(subexpressions\)            */

#define NBRA    9

/*              values for wflag                        */

#define READ    0
#define WRITE   1
#define APPEND  2

/*              values for pflag and ppflag             */

#define PRINT   1
#define LIST    2

/*              values for sflag                        */

#define XCMD    1
#define GCMD    2
#define NCMD    4

/*              values for oflag                        */

#define ONEWL   1
#define OEXPR   2
#define OBEGN   4
#define OPMOD   8

/*              control keys for open mode              */

#include "ctrlkey.h"
#define NEXTCHAR        CTRLN
#define NEXTWORD        CTRLA
#define LINEEND         CTRLE
#define BACKCHAR        CTRLX
#define BACKWORD        CTRLB
#define BACKBEGIN       CTRLY
#define RETYPE          CTRLR
#define DELCHAR         DEL
#define DELCHARA        CTRLUDL
#define DELWORD         CTRLW
#define DELEND          CTRLF
#define DELBEGIN        CTRLU
#define HELP            CTRLD
#define MARGIN          CTRLG
#define SCOPEMOD        CTRLS
#define INTERRUPT       CTRLC
#define CLOSE           CTRLZ
#define CLOSEA          ESC
#define SPELL           CTRLV
