.TH XNSPRINT 1 Cornell
.\" $Header: xnsprint.n,v 1.4 87/01/15 16:57:15 ed Exp $
.UC 4
.tr -\-
." differences between troff and nroff compensated here:
.ie t .ds sc \(sc
.el .ds sc section\
.ds lq \&"\"
.ds rq \&"\"
.if t \
.	ds rq ''
.if t \
.	ds lq ``
.SH NAME
xnsprint \- Print an interpress master on a Xerox NS print server
.SH SYNOPSIS
xnsprint [options] file [file ...]
.SH DESCRIPTION
.I Xnsprint 
delivers the interpress master in \*(lqfile\*(rq 
to a Xerox Network Systems
print server for formatting and printing.  
If no printer is specified, the value of the environment variable PRINTER 
will be used. If this variable has no value, the first printer found in
the local Clearinghouse is used.
.PP
.I Xnsprint 
first requests status
information from the print server, and delays actually sending the file until
the server's spooler is available.  Unless the -q flag is specified, the printer
status information received will be written to standard out.
If an attempt to send the file(s) to the printer fails, a status value is
returned to the caller which can be used to determine whether retrying is
appropriate.  Currently, a status of 0 indicates that the file was
successfully sent to the printer, a status of 1 indicates that continued
retries are appropriate, 2 suggests retrying a few times then giving up, and
3 indicates a hard error which should make the caller give up.
.PP
The possible options are:
.TP
.BI -c \ n
Causes
.I n
copies of the output to be printed.  The default is 1.
.TP
.BI -n \ name
Sets the delivery address of your output (the \*(lqFor\*(rq field on the
cover sheet) to
.IR name .
The default is your full name as recorded in the gecos field of the password
file (\*(lq/etc/passwd\*(rq).
.TP
.BI -b \ banner
Uses
.I banner
to label the output.  It will appear on the cover page on the line labeled
\*(lqDocument\*(rq.  The default is the name of the input file.
.TP
.BI -P \ printer
.TP
.BI -h \ printer
Delivers the interpress master to
.IR printer ,
where 
.I printer
is either the clearinghouse name or the network address of the print server.
If an incomplete clearinghouse name (e.g. \*(lqslander\*(rq) is specified,
domain and organization fields are defaulted using 
.IR CH.default .
.TP
.B -r
Causes 
.I xnsprint
to unlink the input file after delivery to the print server.
.TP
.B -q
Causes
.I xnsprint
to be quiet about printer status and file delivery.  Messages indicating that
the printer needs human attention will still be displayed.
.TP
.BI -a \ filename
Write lpd(8) status information to the file
.IR filename .
.TP
.B -l
Request legal-sized paper.  If the printer has legal paper mounted in one
tray, that tray will be used.
.TP
.BI -s \ papersize
Request
.I papersize
sized paper.  The argument may be an integer or one of ``usLetter,''
``usLegal,'' ``a0,'' etc.  If the requested paper size is not available a
serviceUnavailable error will be returned.
.TP
.BI -m \ message
Use
.I message
as the value for the message field passed to the printer and printed on the
cover sheet.  Default is your
printer's XNS host name, for want of anything better.
.TP
.BI -W
Causes
.I xnsprint
to wait until the files sent are actually printed before returning.
Appropriate status messages are displayed during the waiting period.
.SH FILES
.nf
/etc/passwd		for user names
/usr/new/lib/xnscourier/CH.default	for Clearinghouse defaults
.fi
.SH "SEE ALSO"
maha(1), dipress(1)
.PP
Interpress Electronic Printing Standard, \s8XSIS\s0 048404
.SH DIAGNOSTICS
Various messages stating that the printer is unavailable or needs some kind
of attention.
.SH BUGS
Probably lots of them.  In particular, the 
.B -l
flag should be generalized.
.PP
The printer claims that it \*(lqNeeds Key Operator\*(rq when it is really just
warming up.
.PP
.SH AUTHORS
JQ Johnson, Larry Parmelee, and Bill Nesheim
.PP
