.TH "CREDENTIALS" 3 "3-Feb-87" Cornell
.\" $Header: credentials.n,v 1.2 87/04/01 13:55:40 ed Exp $
.SH NAME
GetSimpleCredsAndVerifier
MakeSimpleCredsAndVerifier,
\- Authentication credentials/verifier creation routines
.SH SYNOPSIS
.PP
.nf
.B "#include <xnscourier/Authentication2.h>"
.PP
.B "GetSimpleCredsAndVerifier(name, pwd, credentials, verifier)"
.B "	Authentication2_Clearinghouse_Name *name;"
.B "	char *pwd;"
.B "	Authentication2_Credentials *credentials;"
.B "	Authentication2_Verifier *verifier;"
.PP
.B "MakeSimpleCredsAndVerifier(name, pwd, credentials, verifier)"
.B "	Authentication2_Clearinghouse_Name *name;"
.B "	char *pwd;"
.B "	Authentication2_Credentials *credentials;"
.B "	Authentication2_Verifier *verifier;"
.f
.PP
Link with
.IR "-lcourier" .
.SH DESCRIPTION
.PP
.I GetSimpleCredsAndVerifier
determines the user name and simple verifier by
calling
.I getXNSuser
and then creates the appropriate simple credentials and verifier returning 
them in the areas pointed to by the arguments
.I credentials
and
.IR verifier .
.I GetSimpleCredsAndVerifier
also returns the user Clearinghouse name in the area and the ascii form of 
the simple verifier in the area pointed to by
.I name
and
.I pwd 
respectively. This is used in conjunction with the use of
.I xnscreds
which sets the appropriate environment variables for
.B XNSNAME
and 
.BR XNSPASSWD .
.PP
The routine
.I MakeSimpleCredsAndVerifier
creates a set of Authentication credentials and verifier of type simple from
the user name (in Clearinghouse 3-part format) and password supplied in the 
arguments
.I name
and 
.IR pwd .
The created credentials and verifier are returned in the areas pointed to by
the arguments
.I credentials
and
.IR verifier .
.PP
.I MakeSimpleCredsAndVerifier
is maintained for backward compatiblity.
.SH NOTES
At this time only the simple flavor of credentials and verifiers are 
supported.
.SH FILES
/usr/local/lib/libcourier.a		-lcourier library.
.SH SEE ALSO
getXNSuser(3n), xnscreds(1n)
.br
``XNS Courier Under Unix''
.br
Authentication Protocol, \s8XSIS\s0 098404 (April 1984).
.SH AUTHOR
J.Q. Johnson

