.TH RMPROJECT 1P "22 June 1983"
.UC 4
.SH NAME
rmproject \- remove a project root directory
.SH SYNOPSIS
.B rmproject
[\-\fBfru\fR]
[{+\^\-}\fBT\fR type[,type ...]]
projectname ...
.SH DESCRIPTION
.I Rmproject
deletes a project called
.I projectname.
The project must be empty.
.PP
If the
.B \-r
option is specified,
.I rmproject
recursively deletes the entire contents of a project root directory,
and the directory itself. The user is asked to confirm the generated
.I "rm -r"
command before the project is deleted. Subdirectories that are project
root directories must be removed using
.I rmproject
prior to removing
.I projectname.
Write permission is required in all subdirectories.
.PP
.I Rmproject
may also be used to convert an existing project root directory to a
regular directory using the
.B \-u
option. However, subdirectories that are
project root directories must be undefined using
.I "rmproject -u"
prior to undefining
.I projectname.
.SH OPTIONS
.IP \fB\-f\fR
Stands for force. No questions are asked. This option overrides any mode
restrictions.
.IP \fB\-r\fR
Recursively remove project directories.
.IP \fB\-u\fR
Undefine a project root directory and convert it to a regular directory.
.IP "\fB\-T\fI type\fR"
Remove a type label from a project root directory.
.SH FILES
.ta \w'..._temp'u+.5i
\&...	Project link directory.
.br
\&..._temp	Temporary project link directory.
.DT
.SH "SEE ALSO"
mkproject(1P), rm(1), rmdir(1)
.SH DIAGNOSTICS
The error message, ``rmproject: \fIproject\fR/... temporarily unavailable'',
indicates that a `..._temp' temporary project link directory exists. This could
be because another user is altering the project link directory, or because a
system crash terminated
.I rmproject
prematurely. If the latter case, then removing the temporary file will fix
the problem.
.PP
When attempting to remove a project, error message ``rmproject:
\fIproject\fR/...: No such file or directory'' followed by error message
``rmproject: force removal by typing `rmproject -F projectname' ''
indicates that a project link directory is missing. In this case,
.I projectname
must be an absolute project pathname.
.PP
When attempting to undefine a project, error message ``rmproject:
\fIproject\fR/...: No such file or directory'' followed by error message
``rmproject: force conversion by typing `rmproject -uF projectname' ''
indicates that a project link directory is missing. In this case,
.I projectname
must be an absolute project pathname.
.PP
Exit status 0 is normal. Exit status 1 indicates an error.
.SH AUTHOR
Peter J. Nicklin
.SH BUGS
There is no restriction on overlapping project hierarchies.
A project root directory that is part of another project hierarchy
will be removed without complaint.
.PP
If a project root directory has already been removed by the
.I rmdir
or
.I "rm -r"
commands, that directory must be recreated using
.I mkdir
before
.I rmproject
will remove the project.
