############################################################
############################################################
#####
#####		SENDMAIL CONFIGURATION FILE
#####
##### $Header:   RCS/lll-tis.mc.v  Revision 1.1  83/09/13  12:34:22  wss  Exp$
#####
##### $Log:	RCS/lll-tis.mc.v $
##### Revision 1.1  83/09/13  12:34:22  wss
##### Initial revision
#####
#####
############################################################
############################################################

include(version.m4)

############################################################
############################################################
#####
#####	Class and macro definitions
#####
#####	name	C/D	Meaning
#####	----	---	-------
#####	w	CD	equivalent local names
#####	U	CD	uucp hostnames
#####	D	CD	local domain names
#####	A	CD	ARPANET gateway
#####	R	CD	Relay
#####	T	C	top-level domains
#####
############################################################
############################################################

Cwlll-tis tis lll-unix lll-comp
DUlll-tis
CUlll-tis
DDLLNL
CDLLNL
CTLOCAL ARPA UUCP
DAlll-tis
CAlll-tis
DRlll-tis
CRlll-tis

###################
###   Options   ###
###################

# we have full sendmail support here
Oa
# mail back errors
Oem
# location of alias file
OA/usr/lib/aliases.new
# default delivery mode (deliver in background)
Odbackground
# (don't) connect to "expensive" mailers
#Oc
# temporary file mode
OF0600
# default GID
Og1
# location of help file
OH/usr/lib/sendmail.hf
# log level
OL9
# default messages to old style
Oo
# queue directory
OQ/usr/spool/mqueue
# read timeout -- violates protocols
Or2h
# status file
OS/usr/lib/sendmail.st
# queue up everything before starting transmission
Os
# default timeout interval
OT3d
# time zone names (V6 only)
OtPST,PDT
# default UID (daemon)
Ou1
# wizard's password
OWa/FjIfuGKXyc2

##########################
###   Trusted users    ###
##########################

Troot
Tdaemon
Tuucp
Tnetwork
Tsys
Twss

###############################
###   Message precedences   ###
###############################

Pfirst-class=0
Pspecial-delivery=100
Pjunk=-100

##########################
###   Special macros   ###
##########################

# my official hostname
Dj$w.ARPA
# my name
DnMAILER-DAEMON
# UNIX header format
DlFrom $g  $d
# delimiter (operator) characters
Do.:%@!^=/[]
# format of a total name
Dq$g$?x ($x)$.
# SMTP login message
De$j Sendmail $v/$V ready at $b



#############################
###   Format of headers   ###
#############################

H?P?Return-Path: <$g>
HReceived: $?sfrom $s $.by $j ($v/$V)
	id $i; $b
H?D?Resent-Date: $a
H?D?Date: $a
H?F?Resent-From: $q
H?F?From: $q
H?x?Full-Name: $x
HSubject:
H?M?Resent-Message-Id: <$t.$i@$j>
H?M?Message-Id: <$t.$i@$j>


############################################################
############################################################
#####
##### Rulesets:
#####
#####	0	applied after ruleset 3 to resolve a recipient
#####		address
#####
#####	1	rewrite sender addresses
#####	2	rewrite recipient addresses
#####
#####	3	(called first) map addresses to canonical form
#####
#####	4	applied to all addresses in the message
#####
############################################################
############################################################

################################
# Recipient address resolution #
################################

S0

# first make canonical
R$*<$*>$*		$1$2$3				defocus
R$+			$:$>3$1				make canonical

# handle special cases.....
R@			$#local$:MAILER-DAEMON		handle <> form
R$*<@[$+]>$*		$#tcp$@[$2]$:$1@[$2]$3		numeric internet spec

# arrange for local names to be fully qualified
#R$*<$*$=S>$*		$1<$2$3.LOCAL>$4		user@etherhost
#R$*<$*$=Z>$*		$1<$2$3.LOCAL>$4		user@berkhost
#R$*<$+.ARPA.LOCAL>$*	$1<$2.ARPA>$3			because ARPA is a host

# now delete the local info
R$*<$*$=w.LOCAL>$*	$1<$2>$4			thishost.LOCAL
R$*<$*$=w.ARPA>$*	$1<$2>$4			thishost.ARPA
R$*<$*$=w.UUCP>$*	$1<$2>$4			thishost.UUCP
R$*<$*$=w>$*		$1<$2>$4			thishost
R$*<$*.>$*		$1<$2>$3			drop trailing dot
R<@>:$*			$@$>0$1				retry after route strip
R$*<@>			$@$>0$1				strip null trash & retry

###
###  Machine dependent part of ruleset zero
###

# resolve explicitly arpanet names (to avoid with machine name "arpa" below)
R$*<@$*$-.ARPA>$*	$#tcp$@$3$:$1<@$2$3.ARPA>$4	user@domain.ARPA

# resolve local UUCP links (all others)
R<@$+.$-.UUCP>:$+	$#uucp$@$2$:@$1.$2.UUCP:$3	@host.domain.UUCP: ...
R<@$-.UUCP>:$+		$#uucp$@$1$:$2			@host.UUCP: ...
R$+<@$+.$-.UUCP>	$#uucp$@$3$:$1@$2.$3.UUCP	user@host.domain.UUCP
R$+<@$-.UUCP>		$#uucp$@$2$:$1			user@host.UUCP

# other non-local names will be kicked upstairs
R$*<@$*$->$*		$#tcp$@$3$:$1<@$2$3>$4		user@host

# everything else is a local name
R$+			$#local$:$1			local names

################################
#  Sender Field Pre-rewriting  #
################################
S1
#R$*<$*>$*		$1$2$3				defocus

###################################
#  Recipient Field Pre-rewriting  #
###################################
S2
#R$*<$*>$*		$1$2$3				defocus

###########################
#  Name Canonicalization  #
###########################
S3

# ========================================
# Basic textual canonicalization
#
# We guarantee that the input has had all
# <> pairs eliminated from it by the time
# we are finished with these rules.
#
# This is because we use <> internally for
# focusing.
# ========================================

# handle "from:<>" special case
R<>			$@@				turn into magic token

R$*<$+>$*		$2				basic RFC821/822 parsing
R$+ at $+		$1@$2				"at" -> "@" for RFC 822
R$*<$*>$*		$1$2$3				in case recursive

# ========================================
# handle source routing
# ========================================

# make sure <@a,@b,@c:user@d> syntax is easy to parse -- undone later
R@$+,$+			@$1:$2				change all "," to ":"

# localize and dispose of domain-based addresses
R@$+:$+			$@$>6<@$1>:$2			handle <route-addr>

# ========================================
# more miscellaneous cleanup
# ========================================

R$+			$:$>8$1				host dependent cleanup
R$+:$*;@$+		$@$1:$2;@$3			DONE: list syntax
R$+@$+			$:$1<@$2>			focus on domain
R$+<$+@$+>		$1$2<@$3>			move gaze right
R$+<@$+>		$@$>6$1<@$2>			DONE: already canonical

# ========================================
# convert old-style addresses to a
# domain-based address
# ========================================

R$+%$+			$@$>6$1<@$2>			DONE: user%host
R$-:$+			$@$>6$2<@$1>			DONE: host:user
R$-.$+			$@$>6$2<@$1>			DONE: host.user
R$+^$+			$1!$2				convert ^ to !
R$-!$+			$@$>6$2<@$1.UUCP>		DONE: resolve uucp names

#################################
#  Final Output Post-rewriting  #
#################################
S4

R@			$@				handle <> error addr

# externalize local domain info
R$*<$*LOCAL>$*		$1<$2$D>$3			change local info
R$*<$+>$*		$1$2$3				defocus
R@$+:$+:$+		$@@$1,$2:$3			<route-addr> canonical

# UUCP must always be presented in old form
# single host name only
R$+@$-.UUCP		$2!$1				u@h.UUCP => h!u

# delete duplicate local names -- mostly for arpaproto.mc
R$+%$=w@$=w		$1@$3				u%UCB@UCB => u@UCB
R$+%$=w@$=w.ARPA	$1@$3.ARPA			u%UCB@UCB => u@UCB

#################################
#				#
# Special local conversions	#
# Called by ruleset 3		#
#				#
# These rules expect that the	#
# portion of the address under	#
# scrutiny will be enclosed in	#
# angle brackets <>		#
#				#
#################################

S6
R$*<@$*$=D>$*		$1<@$2LOCAL>$4			convert local domain
R$*<@$*$=D.ARPA>$*	$1<@$2LOCAL>$4
R$+%$+<@LOCAL>		$1<@$2.LOCAL>			hack for % syntax
R$*<@$+.$=T.$=T>$*	$1<@$2.$3>$5			make UUCP top level
R$*<@$+.$=T.$=T>$*	$1<@$2.$3>$5			make UUCP top level

####################################
#  Host dependent address cleanup  #
#  Called by ruleset 3             #
####################################

S8
R$*$=U!$+@$+		$3@$4				drop uucp forward


############################################################
############################################################
#####
#####		Local and Program Mailer specification
#####		adapted from localm.m4	v4.1	7/25/83
#####
############################################################
############################################################

Mlocal,	P=/usr/lib/mailers/localmail, F=flsDFmnx, S=10, R=20, A=mail -f $f $u
Mprog,	P=/bin/sh,   F=lsDFMe,   S=10, R=20, A=sh -c $u

##################################################
# Sender rewriting for local and program mailers #
##################################################

S10
R@			MAILER-DAEMON			errors to mailer-daemon

############################################################
############################################################
#####
#####		Arpanet TCP Mailer specification
#####
#####		@(#)tcpm.m4	4.1		7/25/83
#####
############################################################
############################################################

Mtcp,	P=[IPC], F=msDFMueXL, S=14, R=14, A=IPC $h, E=\r\n

#################################################################
# Rewrite sender and recipient addresses for ARPANET TCP mailer #
#################################################################

S14

# pass <route-addr>'s through
R<@$+>$*		$@<@$1>$2			resolve <route-addr>

# map colons to dots everywhere.....
R$*:$*			$1.$2				map colons to dots

# handle the simple case....
R$+<@$-.ARPA>		$@$1<@$2.ARPA>			user@host.ARPA

# output local hosts in user%host@lll-tis syntax
R$+<@LOCAL>		$@$1<@$A>			local names
R$+<@$+.LOCAL>		$@$1%$2<@$A>			local hosts

# handle other external cases
R$+<@$->		$@$1<@$2>			no .ARPA on simple names
R$+<@$+.$-.ARPA>	$@$1%$2<@$3.ARPA>		approximate something
R$+<@[$+]>		$@$1<@[$2]>			already ok

# convert remaining addresses to old format and externalize appropriately
R$+			$:$>5$1				=> old format
R$-:$+			$@$1.$2<@$A>			convert berk hosts
R$+<@$+>		$@$1%$2<@$A>			pessmize
R$+			$:$1%$w<@$A>			tack on our hostname
R$+%$=R<@$=A>		$1<@$3>				strip unneeded relay

############################################################
############################################################
#####
#####		UUCP Mailer specification
#####		Adapted from uucpm.m4	4.2	8/30/83
#####
############################################################
############################################################

ifdef(`m4COMPAT',, `include(compat.m4)')

Muucp,	P=/usr/bin/uux, F=sDFMhuU, S=13, R=23, M=100000,
	A=uux - -r $h!rmail ($u)


##################################
# Sender rewriting for uucp mail #
##################################

S13
R$+			$:$>5$1				convert to old style
R$=w!$+			$2				strip local name
R$*<@$->$*		$1<@$2.ARPA>$3			resolve abbreviations
R$+			$:$U!$1				stick on our host name
#R$=w!$=R:$+		$:$1!$3				ucbvax!ucbvax:xxx

#####################################
# Recipient rewriting for uucp mail #
#####################################

S23
R$+			$:$>5$1				convert to old style
R$*<@$->$*		$1<@$2.ARPA>$3			resolve abbreviations
