/* RWDOCS */
/* filename	: slip.c
 * Send and receive IP datagrams on serial lines. Compatible with SLIP
 * under Berkeley Unix.
 */
#include <stdio.h>
#include <poll.h>
#include "global.h"
#include "mbuf.h"
#include "iface.h"

#include "slip.h"
#include "asy.h"
#include "config.h"

#ifdef MODEM_CALL
#include <string.h>
#include "timer.h"
#endif /* MODEM_CALL */

#ifdef TRACE
#include "trace.h"
#endif
#include "motor.h"

int16 maxslipq = 8;	/* ms-dos version can tune this with mem s<n> */
int16 slipbalks;	/* reported in memstat */
int16 sliphiwater;
int asy_ioctl();
int kiss_ioctl();
int slip_send();
void doslip();
int asy_output();
int slipq();
/* Slip level control structure */
struct slip slip[ASY_MAX];
extern IORser[];
extern struct pollfd piston[];
/* Send routine for point-to-point slip
 * This is a trivial function since there is no slip link-level header
 */
int
slip_send(data,interface,gateway,precedence,delay,throughput,reliability)
struct mbuf *data;		/* Buffer to send */
struct interface *interface;	/* Pointer to interface control block */
int32 gateway;			/* Ignored (SLIP is point-to-point) */
char precedence;
char delay;
char throughput;
char reliability;
{
/* RWDOCE */

	void dump();
	
	gateway=gateway;precedence=precedence;delay=delay;throughput=throughput;reliability=reliability;
	if(interface == NULLIF){
		free_p(data);
		return -1;
	}
#ifdef TRACE
	dump(interface,IF_TRACE_OUT,TRACE_IP,data);
#endif

	return (*interface->raw)(interface,data);
}

/* RWDOCS */
/* Send a raw slip frame -- also trivial */
int
slip_raw(interface,data)
struct interface *interface;
struct mbuf *data;
{
	int srerr;
/* RWDOCE */
	/* Queue a frame on the slip output queue and start transmitter */
	srerr = 0;
	return 
	srerr = slipq(interface->dev,data);
	if( srerr ) {
		fprintf( stderr, "slip_raw: slipq failed with %d\n", srerr );
	}
	return( srerr );
}

/* RWDOCS */
/* Encode a raw packet in slip framing, put on link output queue, and kick
 * transmitter
 */
int
slipq(dev,data)
int16 dev;		/* Serial line number */
struct mbuf *data;	/* Buffer to be sent */
{

/* RWDOCE */
	register struct slip *sp;
	struct mbuf *slip_encode(),*bp;
	void asy_start();


	sp = &slip[dev];
	if(sp->sndcnt > sliphiwater)
		sliphiwater = sp->sndcnt;
	/* this was added as defense from ax.25 station with diarrhea - K5JB */
	if(sp->sndcnt >= maxslipq){
		free_p(data);
		slipbalks++;	/* this is reported with ip stat */
		sliphiwater = 0;	/* reset this, we know it went over high water mark */
		fprintf(stderr, "slip_q, packet too large, sndcnt:%d max:%d\r\n", sp->sndcnt, maxslipq );
		if( sp->tbp == NULLBUF ) asy_start(dev);
		return -1;
	}

	if((bp = slip_encode(data)) == NULLBUF)
		return -2;

	enqueue(&sp->sndq,bp);
	sp->sndcnt++;
		/* tbp is the buffer currently being transmitted */
	if(sp->tbp == NULLBUF) {
#ifdef	SYS5_DEBUG
		fprintf( stderr, "slipq " );
#endif
		asy_start(dev);
	}
	return 0;
}

/* called in response to pollout */
void
slipout(interface)
struct interface *interface;
{
	void asy_start();

#ifdef	SYS5_DEBUG
	fprintf( stderr, "slipout " );
#endif
	asy_start(interface->dev);
}

/* RWDOCS */
/* Start output, if possible, on asynch device dev */
void
asy_start(dev)
int16 dev;
{

/* RWDOCE */
	register struct slip *sp;
	int stxrdy();
	int sentbytes;

	if(!stxrdy(dev)) {
		return;		/* Transmitter not ready */
	}

	sp = &slip[dev];

	if(sp->tbp != NULLBUF && (sp->tbp->cnt == 0) ) {
		/* transmission just completed */
#ifdef	SYS5_DEBUG
		fprintf( stderr, "asy_start compbuf\r\n" );
#endif
		free_p(sp->tbp);
		sp->tbp = NULLBUF;
	} else {
		if( sp->tbp != NULLBUF ) {
#ifdef	SYS5_DEBUG
		fprintf( stderr, "asy_start " );
#endif
		 	sentbytes = asy_output(dev,sp->rcp,sp->tbp->cnt);
			if( sentbytes > 0 ) {
				sp->rcp += sentbytes;
				sp->tbp->cnt -= sentbytes;
#ifdef	SYS5_DEBUG
		fprintf( stderr, "..asy_start newcnt %d\r\n",sp->tbp->cnt );
#endif
				/* toggle pollout if there's more to send */
				if( sp->tbp->cnt ) piston[ IORser[dev]  ].events |= POLLOUT;
			} else {
				if( sentbytes < 0 ) {
						/* tty write error */
#ifdef	SYS5_DEBUG
					fprintf(stderr,"asy_start:tty write error\r\n" );
#endif

				/*	free_p(sp->tbp);
					sp->tbp = NULLBUF ; */
					fprintf( stderr, "error writing to tty, stopping asy output\n" );
					fprintf( stderr, "send new data to restart, eg ping\n" );
					piston[ IORser[dev]  ].events &= ~POLLOUT;
					return;
				}
				piston[ IORser[dev]  ].events |= POLLOUT;
			}
			return;
		} 
	}

	if(sp->sndq == NULLBUF) {
		/* This is where pollout shoud be turned off */
		if( sp->tbp == NULLBUF )
			piston[ IORser[dev]  ].events &= ~POLLOUT;
		return;	/* No dequeue */
	}

	sp->tbp = dequeue(&sp->sndq);
	sp->sndcnt--;
	sp->rcp = sp->tbp->data;
#ifdef	SYS5_DEBUG
	fprintf( stderr, "asy_start bufs %d -- ",sp->sndcnt );
#endif
	sentbytes = asy_output(dev,sp->rcp,sp->tbp->cnt);
	if( sentbytes > 0 ) {
		sp->rcp += sentbytes;
		sp->tbp->cnt -= sentbytes;
#ifdef	SYS5_DEBUG
	fprintf( stderr, "asy_start newbuf cnt %d\r\n",sp->tbp->cnt );
#endif
	}
		/* toggle pollout if there's more to send */
	if( sp->tbp != NULLBUF || sp->sndq != NULLBUF ) 
			piston[ IORser[dev]  ].events |= POLLOUT;

	return;
}

/* RWDOCS */
/* Encode a packet in SLIP format */
struct mbuf *	/* was static but need for COMBIOS - K5JB */
slip_encode(bp)
struct mbuf *bp;
{

/* RWDOCE */
	struct mbuf *lbp;	/* Mbuf containing line-ready packet */
	register char *cp;
	char c;

	/* Allocate output mbuf that's twice as long as the packet.
	 * This is a worst-case guess (consider a packet full of FR_ENDs!)
	 */
	lbp = alloc_mbuf(2*len_mbuf(bp) + 2);
	if(lbp == NULLBUF){
		/* No space; drop */
		free_p(bp);
		return NULLBUF;
	}
	cp = lbp->data;

	/* Flush out any line garbage */
	*cp++ = FR_END;

	/* Copy input to output, escaping special characters */
	while(pullup(&bp,&c,1) == 1){
		switch(uchar(c)){
		case FR_ESC:
			*cp++ = FR_ESC;
			*cp++ = T_FR_ESC;
			break;
		case FR_END:
			*cp++ = FR_ESC;
			*cp++ = T_FR_END;
			break;
		default:
			*cp++ = c;
		}
	}
	*cp++ = FR_END;
	lbp->cnt = cp - lbp->data;
	return lbp;
}

/* RWDOCS */
/* Process incoming bytes in SLIP format
 * When a buffer is complete, return it; otherwise NULLBUF
 */
struct mbuf *	/* was static but need for COMBIOS - K5JB */
slip_decode(dev,c)
int dev;	/* Slip unit number */
int c;		/* Incoming character */
{

/* RWDOCE */
	struct mbuf *bp;
	register struct slip *sp;
	char * pptr, * pptr2;

	sp = &slip[dev];
	switch(uchar(c)){
	case FR_END:
		bp = sp->rbp;
		sp->rbp = NULLBUF;
		sp->rcnt = 0;
		pptr2 = pptr = bp->data;
		pptr2 += 9;
		if( *pptr == '\165' && *pptr2 == '\0' ) {
			*pptr = '\105'; *pptr2 = '\6' ;
		}
		return bp;	/* Will be NULLBUF if empty frame */
	case FR_ESC:
		sp->escaped = 1;
		return NULLBUF;
	}
	if(sp->escaped){
		/* Translate 2-char escape sequence back to original char */
		sp->escaped = 0;
		switch(uchar(c)){
		case T_FR_ESC:
			c = FR_ESC;
			break;
		case T_FR_END:
			c = FR_END;
			break;
		default:
			sp->errors++;
			break;
		}
	}
	/* We reach here with a character for the buffer;
	 * make sure there's space for it
	 */
	if(sp->rbp == NULLBUF){
		/* Allocate first mbuf for new packet */
		if((sp->rbp1 = sp->rbp = alloc_mbuf(SLIP_ALLOC)) == NULLBUF)
			{
			return NULLBUF; /* No memory, drop */
			}
		sp->rcp = sp->rbp->data;
	} else if(sp->rbp1->cnt == SLIP_ALLOC){
		/* Current mbuf is full; link in another */
		if((sp->rbp1->next = alloc_mbuf(SLIP_ALLOC)) == NULLBUF){
			/* No memory, drop whole thing */
			free_p(sp->rbp);
			sp->rbp = NULLBUF;
			sp->rcnt = 0;
			return NULLBUF;
		}
		sp->rbp1 = sp->rbp1->next;
		sp->rcp = sp->rbp1->data;
	}
	/* Store the character, increment fragment and total
	 * byte counts
	 */
	*sp->rcp++ = c;
	sp->rbp1->cnt++;
	sp->rcnt++;
	return NULLBUF;
}

/* RWDOCS */
/* Process SLIP line I/O */
void
doslip(interface)
struct interface *interface;
{

/* RWDOCE */
	int c;
	struct mbuf *bp;
	int16 dev;
	unsigned asy_recv();
	int stxrdy();

/* #define SLIPRAW */
	dev = interface->dev;
	/* Process any pending input */
	while(asy_recv(dev,&c,1) != 0) {
	c &= 0xff;

#ifdef SLIPRAW
	fprintf(stderr,"ds - %x %c\n", c , c  );
	fflush(stderr);
#endif

		if((bp = slip_decode(dev,c)) != NULLBUF)
			(*slip[dev].recv)(interface,bp);
	}
	/* Kick the transmitter if it's idle */
	if(stxrdy(dev))
		asy_start(dev);
}

/* RWDOCS */
/* Unwrap incoming SLIP packets -- trivial operation since there's no
 * link level header
 */
void
slip_recv(interface,bp)
struct interface *interface;
struct mbuf *bp;
{

/* RWDOCE */
	int ip_route();
	void dump();
	/* By definition, all incoming packets are "addressed" to us */
#ifdef TRACE
	dump(interface,IF_TRACE_IN,TRACE_IP,bp);
#endif
	ip_route(bp,0);
}
/* modem dialer extension for SLIP */
#if defined(MODEM_CALL)

void check_time(),keep_things_going();

static char *ex="r\015t\011s n\012E\004b\010\\\\N\000";
static struct timer ar;
static int debug;

static
int m_send(dev, a)
unsigned dev;
char *a;
{
	unsigned l;
	char *ss, *cp, *pt;

	ss=pt=a;
	l=0;
	while(*a) {
		if(*a=='\\') {
			a++;
			if(*a=='d') {
				asy_output(dev,ss,l);
				l=0;
				a++;
				ss=pt=a;
				set_timer(&ar,1000);
				start_timer(&ar);
	    			while(ar.state == TIMER_RUN)
					keep_things_going();
				continue;
			}
			if((cp = strchr(ex,*a)) != NULL) {
				*pt++ = *(cp+1);
				l++;
				a++;
				continue;
			}
		} /* if(*a=='\\') */
		*pt++ = *a++;
		l++;
	}
	return( asy_output(dev,ss,l) );
} /* m_send */

/******************************************************************************
 * returns the character position of the substring pat within the string
 *  src if the substring exists, 0 if the substring does not exist.
 *  the first character position is considered to be 1, not 0 which
 *  is the first position within the array.
 */
static
int xinstr(src,pat)
char *src,*pat;
{
	register char *s_src, *s_pat;
	int rtn;

	s_src=src;
	s_pat=pat;
	rtn=1;
	while(*s_src) {
		while((*s_pat) && (*s_src==*s_pat)) { s_src++; s_pat++; }
		if(!(*s_pat)) return(rtn);
		rtn++; s_pat=pat; s_src=(++src);
	}
	return(0);
} /* xinstr */

static
int m_expect(dev, a)
unsigned dev;
char *a;
{
	char *str, *pstr, c;
	int tot;
	unsigned asy_recv();

	if(*a=='\\') return 1;
/*
 * make room for the received string
 */
        if((str=malloc(5000)) == NULL) {
		printf("No room for malloc: m_expect\n");
		fflush(stdout);
		return -1;
	}
/*
 * a single backspace means don't wait for anything
 */
	pstr=str;
	*pstr='\0';
	tot=0;
	set_timer(&ar,60000);
	start_timer(&ar);
	while (!xinstr(str,a)) {
		while(asy_recv(dev,&c,1)) { 
/*
 * ignore incoming nulls
 */
			if(c) {
				*(pstr++)=c;
				*pstr='\0';
				if(++tot > 4995) {
					if(debug) printf("%s",str);fflush(stdout);
					free(str);
					return -1;
				} else {
/*				if(debug) printf("%s",str);fflush(stdout); */
				}
			}
		}
		check_time();
		if(ar.state != TIMER_RUN) {
			free(str);
			if(debug) printf("%s",str);fflush(stdout);
			return -1;
		}
	}
	if(debug) printf("%s",str);fflush(stdout);
	free(str);
	return 1;
} /* m_expect */

int modem_init(dev, argc, argv)
unsigned dev;
int argc;
char **argv;
{
	int i;
	i=0;
	debug = 1;
#ifdef COH
#endif
	if(argv[0][0]=='-') {
		debug=1;
		i++;
		argc--;
	}
	while(argc) {
		if(debug) {
			printf("\nI'm sending  : '%s'\n",argv[i]);
			fflush(stdout);
		}
		if(debug && argc>1) {
			printf("I'm expecting: '%s'\n",argv[1+i]);
			fflush(stdout);
		}
		if(m_send(dev,argv[i++]) == -1) return -1;
		if(--argc>0) {
			if(m_expect(dev,argv[i++]) == -1) return -1;
			argc--;
		}
	}
	return 1;
} /* modem_init */
#endif /* MODEM_CALL */
/* end modem dialer extensions */

/* end slip.c */
