/*
 * Run programs submitted by at.
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/dir.h>
#include <time.h>
#include <sys/stat.h>

# define DIR "/usr/spool/at"
# define PDIR	"past"
# define LASTF "/usr/spool/at/lasttimedone"

int	nowtime;
int	nowdate;
int	nowyear;
int     debug;

main(argc, argv)
char **argv;
{
	int tt, day, year, uniq;
	struct direct dirent;
	char file[DIRSIZ+1];
	FILE *dirf;

	if (argc > 1 && strcmp(argv[1], "-d") == 0) {
		debug = 1;
		setbuf(stdout, NULL);
	}
	chdir(DIR);
	makenowtime();
	if ((dirf = fopen(".", "r")) == NULL) {
		fprintf(stderr, "Cannot read at directory\n");
		exit(1);
	}
	if (debug)
		printf("Atrun: nowyear %d nowdate %d nowtime %d\n", nowyear, nowdate, nowtime);
	while (fread((char *)&dirent, sizeof(dirent), 1, dirf) == 1) {
		if (dirent.d_ino==0)
			continue;
		strncpy(file, dirent.d_name, DIRSIZ);
		file[DIRSIZ] = '\0';
		if (debug)
			printf("Atrun checking %s\n", file);
		if (sscanf(file, "%2d.%3d.%4d.%2d", &year, &day, &tt, &uniq) != 4)
			continue;
		if (nowyear < year)
			continue;
		if (nowyear==year && nowdate < day)
			continue;
		if (nowyear==year && nowdate==day && nowtime < tt)
			continue;
		run(file);
	}
	fclose(dirf);
	updatetime(nowtime);
	exit(0);
}

makenowtime()
{
	int t;
	struct tm *localtime();
	register struct tm *tp;

	t = time();
	tp = localtime(t);
	nowtime = tp->tm_hour*100 + tp->tm_min;
	nowdate = tp->tm_yday;
	nowyear = tp->tm_year;
}

updatetime(t)
{
	FILE *tfile;

	tfile = fopen(LASTF, "w");
	if (tfile == NULL) {
		fprintf(stderr, "can't write lastfile\n");
		exit(1);
	}
	fprintf(tfile, "%04d\n", t);
}

run(file)
char *file;
{
	struct stat stbuf;
	register pid, i;
	int junk;
	char sbuf[64];

	if (fork()!=0)
		return;
	if (debug)
		printf("Atrun running %s\n", file);
	else {
		for (i=0; i<15; i++)
			close(i);
		dup(dup(open("/dev/null", 0)));
	}
	sprintf(sbuf, "/bin/mv %.14s %s", file, PDIR);
	if (debug)
		printf("atrun about to call system with '%s' euid %d\n", sbuf, geteuid());
	setuid(0);           /* Mv needs this. */
	system(sbuf);
	chdir(PDIR);
	if (stat(file, &stbuf) == -1) {
		if (debug)
			printf("Atrun: stat failed on %s\n", file);
		exit(1);
	}
	if (pid = fork()) {
		if (pid == -1)
			exit(1);
		wait(&junk);
		unlink(file);
		exit(0);
	}
	setgid(stbuf.st_gid);
	setuid(stbuf.st_uid);
	nice(3);
	if (debug)
		printf("Atrun about to exec shell on %s\n", file);
	execl("/bin/sh", "sh", file, 0);
	fprintf(stderr, "Can't execl shell\n");
	exit(1);
}
