#include "omak.h"

/*
 * break point handling routines
 */

int trace = 0;
int lastbp = 0;
BP *bptail = 0;
BP *bplook();

static int m[] { 8, 4, 2, 1 };

extern struct optab op[];

/*
 * qbp - add a break point to the list
 */

qbp(addr)
register int addr;{

	register BP *p, *bpp;
                 struct optab *pop;
                 struct op470 w;
                 int *i;

	for (bpp = bptail; bpp != NULL; bpp = bpp->bp_next) {
		if (bpp->bp_addr == addr)
			return(bpp);
		}

/* check for illegal instruction at this addr */

        i = addr;
        w = *(struct op470 *)i;
	if ((pop = oplookup(w.opcode)) == NULL)
		if  (w.sopcode > 0xff) pop = oplookup(w.sopcode);
        if (pop == NULL) {
                           aptstr(aptout,
                            "break point set at illegal instruction%s",
                             blankchr);
		           aptio(aptout,0);
                          }
	if((p = bralloc()) == -1) return(-1);
	p->bp_addr = addr;
	p->bp_next = bptail;
	p->bp_cmd = 0;
	p->bp_count = 0;
	p->bp_comment[0] = '\0';
	bptail = p;
	return(p);
	}

/*
 * cont - start execution using the current psw
 *
 *	we have to be careful here because if the location we
 *	want to start at is a break point, we can't go setting
 *	all the break points and then continuing the process (otherwise
 *	the location could never be executed).  So we single step
 *	through the location if it's a break point and then
 *	breeze along as usual.
 */

cont(loc)
register int loc;{

	register BP *bpp;
	register char *s;
	int c, status;
           /*    SYM *sym; */

around:
        if ((bpp = bplook(loc)) != NULL) {
                if (ss(loc)) return;
                }
        setbps();
        onward();
        psw_ptr[1] -= 2; /* reset psw ptr by svc instr length also */
        dotdot = psw_ptr[1];
        lastbp = psw_ptr[1];
        unsetbps();
        if ((bpp = bplook(dotdot)) != NULL) {
          if (bpp->bp_count-- > 1) { goto around; }

/*            aptstr(aptout,"got breakpoint count of %d at %x ",
 *                           bpp->bp_count,bpp->bp_addr);
 *            aptio(aptout,0);
 */
                prinst(bpp->bp_addr,0);
                if (bpp->bp_comment[0] != '\0') {
                         aptstr(aptout, " (break point at %6x) %s",
                                    bpp->bp_addr,bpp->bp_comment);
		         aptio(aptout,0);
                         }
                 else {
                         aptstr(aptout, " (break point at %6x)",
                                              bpp->bp_addr);
		         aptio(aptout,0);
                      }

                if (bpp->bp_cmd) {
                                 doreq(bpp->bp_cmd, 1);
				 if (specialflg) {
				    specialflg = 0;
				    loc = lastbp;
				    goto around; /* your basic kludge */
				    }
				 }
                return;
                }

	}

/*
 * setbps - set the break points on the list
 *	accomplished by zapping the referenced word while saving it's value
 *	also catch all signals in child, ignore in parent
 */

setbps(){

	register BP *p;
	register short int *i;
	short int x = 0x0a5a;

        for (p = bptail; p != NULL; p = p->bp_next) {
                i = p->bp_addr;
                p->bp_val =  *i;
                *i =  x;
                }
	}

/*
 * unsetbps - undo all the dirty work done above
 */

unsetbps(){

	register BP *p;
	short int *i;

        for (p = bptail; p != NULL; p = p->bp_next) {
                  i = p->bp_addr;
                 *i = p->bp_val;
                 }
      }

ss(loc)
  register int loc;
  {
	struct op470 w;
	short int *i;
	      int *j;
        short int value;
        int *temp;
	register struct optab *pop;
        int cc, tmploc, tdot;

            /* dat strikes home, if psw bit 5 is a 1, then lra the addr */

                if (psw_ptr[0] & 0x04000000) {
			if ( (tmploc = omakreal(psw_ptr[1])) < 0) {
                           tmploc = psw_ptr[1];
                           aptstr(aptout, "load real addr problem, die%s",
                                           blankchr);
                           aptio(aptout,0);}
			  }
                   else tmploc = loc;

		j = tmploc;
		w = *(struct op470 *)j; /* get the obj code at this addr*/

	if (w.opcode == SVC)
		pop = &op[0];
	else if ((pop = oplookup(w.opcode)) == NULL)
		if (w.sopcode > 0377)
			pop = oplookup(w.sopcode);
	if (pop == NULL) {
		aptstr(aptout,"Can't recognize opcode: %4x", w.sopcode);
                aptio(aptout,0);
                aptstr(aptout, "Operation exception at location %6x",loc);
		aptio(aptout,0);
		return(-1);
		}


        cc = (psw_ptr[0] >> 12)&03;  /* set up cond code */

	switch(pop->op_type) {
		case RR:
                        if ((pop->op_val == BALR) && (w.r2))
                                loc = gpr_ptr[w.r2];
                        else loc += BPHW;
			break;
		case SS1:
		case SS2:
		case SS3:
                        loc += BPW+BPHW;
			break;
		default:
                        if (pop->op_val == BAL) {
                                loc = w.disp1;
                                if (w.r2) loc += gpr_ptr[w.r2];
                                if (w.base1) loc += gpr_ptr[w.base1];
                                }
                        else loc += BPW;
			break;
		case BRANCHR:
                        if (m[cc]&w.r1)
                                loc = gpr_ptr[w.r2]&0xffffff;
                        else loc += BPHW;
			break;
		case BRANCH:
                        if (m[cc]&w.r1) {
                                loc = w.disp1;
                                if (w.r2) loc += gpr_ptr[w.r2];
                                if (w.base1) loc += gpr_ptr[w.base1];
                                }
                        else loc += BPW;
			break;
		case LPSW:
			if (w.base1 == 0) temp = w.disp1;
                           else temp = gpr_ptr[w.base1] + w.disp1;

            /* dat strikes home, if psw bit 5 is a 1, then lra the addr */

                     if (temp[0] & 0x04000000) {
			        if ( (loc = omakreal(temp[1])) < 0) {
                                   aptstr(aptout,
                                            "trouble with the lra, die%s",
                                            blankchr);
                                   aptio(aptout,0);
                                   loc = temp[1]; }
				else {
			             }
			   }
                           else loc = temp[1];
                        break;
		case BRCNT:
			if ((gpr_ptr[w.r1]-1) == 0) loc += BPW;
                         else { loc = w.disp1;
                                if (w.r2) loc += gpr_ptr[w.r2];
                                if (w.base1) loc += gpr_ptr[w.base1];
                              }
                        break;
		case BRCNTR:
			if ((gpr_ptr[w.r1]-1) == 0) loc += BPHW;
                           else if (w.r2) loc = gpr_ptr[w.r2];
                                else loc += BPHW;
                        break;
		}

        if (psw_ptr[0] & 0x04000000) {
                   if ( (loc = omakreal(loc)) < 0) {
                      aptstr(aptout,"trouble with the lra, die%s",
                                     blankchr);
                      aptio(aptout,0);
                      loc = tmploc; }
                     }

	i = loc;
	value = *i;
	*i = 0x0a5a;  /* set up the svc brk point */

        onward();

        psw_ptr[1] -= 2; /* reset psw ptr by svc instr length also */
        if (psw_ptr[0] & 0x04000000) {
                   if ( (tdot = omakreal(psw_ptr[1])) < 0) {
                    aptstr(aptout,"trouble with the lra, die%s",blankchr);
                      aptio(aptout,0);
                      tdot = psw_ptr[1]; }
              }
        else tdot = psw_ptr[1];

        dotdot = psw_ptr[1];
        i = tdot;
        *i = value;   /* put things back together */
        return(0);
    }

/*
 * check to see if a location is a break point
 */

BP *bplook(loc)
register int loc; {

	register BP *p;

	for (p = bptail; p != NULL; p = p->bp_next) {
		if (p->bp_addr == loc) return(p);
		}
	return(NULL);
	}

/*
 * clear a break point
 */

bpclear(loc)
register int loc; {

	register BP *p, *last;

	last = NULL;
	for (p = bptail; p != NULL; p = p->bp_next) {
		if (p->bp_addr == loc) {
			if (last == NULL)
				bptail = p->bp_next;
                          else
                                last->bp_next = p->bp_next;
	                if (p->bp_cmd) apfree(p->bp_cmd);
			brfree(p);
			return;
			}
		last = p;
		}
	aptstr(aptout, "no break point at %-8x", loc);
        aptio(aptout,0);
	}

/*
 * display current break points
 */

dbrks() {

	register BP *p;
                SYM *s;

	if (bptail == NULL) {
		aptstr(aptout,"no break points set%s",blankchr);
		aptio(aptout,0);
		return;
		}
	aptstr(aptout,"break points:%s",blankchr);
	aptio(aptout,0);
	for (p = bptail; p != NULL; p = p->bp_next) {
                if ((s = addrlook(p->bp_addr)) != NULL)  {
                          if (p->bp_comment[0] == '\0')
                                    aptstr(aptout, "  %-8x  %s +%x",
                                                 p->bp_addr,s->name,
                                                 p->bp_addr - s->val);
                              else
                                    aptstr(aptout, "  %-8x  %s +%x  %s",
                                      p->bp_addr,s->name,
			              p->bp_addr - s->val,p->bp_comment);
		          aptio(aptout,0);
                        }
                   else {
                          if (p->bp_comment[0] == '\0')
                                    aptstr(aptout, "  %-8x",p->bp_addr);
                             else
                                aptstr(aptout, "  %-8x  %s",
                                             p->bp_addr,p->bp_comment);
		          aptio(aptout,0);
                        }
		}
	}
