/*
 * Handle I/O to/from an LDEV (VM Logical Device)
 */

#include <tcl/3270.h>
#include <tcl/tclio.h>
#include <errno.h>
#include <stdio.h>

/*
 * Open any available LDEV
 */
ldopen()
{
	static char ldev[] = "/dev/ldevXX";
	int i, ldevoutput(), ldevinput();
	extern errno;

	/*
	 * Find and open a logical device
	 */
	i = 0;
	do {
		sprintf(ldev, "/dev/ldev%d", i++);
		ldfd = open(ldev, 2);
	} while(ldfd == -1 && errno == EBUSY);
	if(ldfd == -1) {
		perror(ldev);
		exit(1);
	}
	_getoutput = ldevoutput;
	_putinput = ldevinput;
}

/*
 * Read 3270 output from LDEV
 */
ldevoutput()
{
	int n;

	n = read(ldfd, (char *)&outbuf, sizeof outbuf - sizeof outbuf.len);
	if(n < 0) {
		perror("ldev read");
		exit(1);
	}
	if(n == 0)
		exit(0);
	outbuf.len = n-1;

	n = 0;
	switch(outbuf.op) {

	case READMOD:
	case READBUF:
		unsolicited = outbuf.op;
		n = 1;
		break;

	case WRITE:
	case EWRITE:
		scroutput();
                if(outbuf.data[0] & RESTORE)
                        kbd = UNLOCKED;
		n = (*Oscan)();
		break;

	default:
		fprintf(stderr, "ldev read: unknown op %x\n", outbuf.op);
		n = 1;
	}
	return(n);
}

/*
 * Write 3270 input to LDEV
 */
ldevinput()
{
	int n;

	n = inbuf.len+1;
	if(write(ldfd, (char *)&inbuf, n) < 0) {
		if(errno == EINVAL) {
			if(inbuf.op == READMOD)
				unsolicited = READBUF;
			else
				unsolicited = READMOD;
			return(1);
		}
		if(errno == EIO) exit(0);       /* ldev terminated */
		perror("ldev write");
	}
	kbd = LOCKED;
	return(0);
}
