#include <stdio.h>
#include <stdioerr.h>

#define min(a, b) (a < b ? a : b)
char *malloc();

fread(ptr, size, count, iop)
int size, count;
register char *ptr;
register FILE *iop;
{
	register c;
	int ndone, s;
	extern int errno;

	if (iop == NULL)
		return(_stdioerr(EFPNULL, "fread"));
	if(count <= 0 || size <= 0)
		return(0);
	if (iop->_flag&_IOMEM)
		return(_mfread(ptr, size, count, iop));

tryagain:
	if(iop->_flag&_IONBF) {
		ndone = 0;
		for (; ndone<count; ndone++) {
			s = size;
			do {
				if ((c = getc(iop)) >= 0)
					*ptr++ = c;
				else
					return(ndone);
			} while (--s);
		}
		return(ndone);
	}

	if (iop->_flag&_IORW)
		iop->_flag |= _IOREAD;

	if ((iop->_flag&_IOREAD) == 0 || iop->_flag&_IOSTRG)
		return(_stdioerr(EBADUSE, "fread", iop->_filename, "reading"));

	if (iop->_base == NULL) {
		if ((iop->_base = malloc(BUFSIZ)) == NULL) {
			iop->_flag |= _IONBF;
			goto tryagain;
		}
		iop->_flag |= _IOMYBUF;
	}

	/* Flush stdout(if a terminal) if reading from a terminal or pipe at stdin */
	if(iop == stdin) {
		if((stdin->_flag & _IOGTTY) == 0) {
			if(isatty(fileno(stdin)) || isapipe(fileno(stdin)))
				stdin->_flag |= _IOTTY;
			stdin->_flag |= _IOGTTY;
		}
		if((stdin->_flag & _IOTTY) && (stdout->_flag & _IOTTY))
			fflush(stdout);
	}

	ndone = 0;
	while(count > 0 && (iop->_flag&(_IOEOF|_IOERR)) == 0) {
		if(iop->_cnt == 0) {
			iop->_ptr = iop->_base;
			c = read(fileno(iop), iop->_base, BUFSIZ);
			if(c > 0) {
				iop->_cnt = c;
			} else if(c == 0)
				iop->_flag |= _IOEOF;
			else {
				iop->_flag |= _IOERR;
		                _stdioerr(errno, "fread", "reading", iop->_filename);
			}
		}
		if(iop->_cnt >= size) {
			c = iop->_cnt / size;
			c = min(c, count);
			ndone += c;
			count -= c;
			c *= size;
			_move(iop->_ptr, ptr, c);
			ptr += c;
			iop->_ptr += c;
			iop->_cnt -= c;
		} else if(iop->_cnt > 0) { /* one the slow way to get new buffer */
			s = size;
			do {
				if ((c = getc(iop)) >= 0)
					*ptr++ = c;
				else
					return(ndone);
			} while (--s);
			ndone++;
			count--;
		}
	}
	return(ndone);
}

fwrite(ptr, size, count, iop)
int size, count;
register char *ptr;
register FILE *iop;
{
	register c;
	register unsigned s;
	unsigned ndone;
	extern char _sobuf[];

	if (iop == NULL)
		return(_stdioerr(EFPNULL, "fwrite"));
	if (count <= 0 || size <= 0)
		return(0);
	if (iop->_flag&_IOMEM)
		return(_mfwrite(ptr, size, count, iop));

tryagain:
	if(iop->_flag&_IONBF) {
		ndone = 0;
		for (; ndone<count; ndone++) {
			s = size;
			do {
				putc(*ptr++, iop);
			} while (--s);
			if (ferror(iop))
				break;
		}
		return(ndone);
	}

	if (iop->_flag&_IORW) {
		iop->_flag |= _IOWRT;
		iop->_flag &= ~_IOEOF;
	}

	if (!(iop->_flag&_IOWRT) || iop->_flag&_IOSTRG)
		return(_stdioerr(EBADUSE, "fwrite", iop->_filename, "writing"));

	if (iop->_base == NULL) {
		if (iop == stdout) {
			if (isatty(fileno(stdout)))
				iop->_flag |= _IOTTY;
			iop->_flag |= _IOGTTY;
			iop->_base = _sobuf;
		} else {
			if ((iop->_base = malloc(BUFSIZ)) == NULL) {
				iop->_flag |= _IONBF;
				goto tryagain;
			}
			iop->_flag |= _IOMYBUF;
		}
		iop->_ptr = iop->_base;
		iop->_cnt = BUFSIZ;
	}

	ndone = 0;
	while(count > 0 && ferror(iop) == 0) {
		if(iop->_cnt == 0) {
			c = iop->_ptr - iop->_base;
			if(c == 0 || write(fileno(iop), iop->_base, c) == c) {
				iop->_ptr = iop->_base;
				iop->_cnt = BUFSIZ;
			} else {
				iop->_flag |= _IOERR;
				_stdioerr(errno, "fwrite", "writing", iop->_filename);
			}
		}
		if(iop->_cnt >= size) {
			c = iop->_cnt / size;
			c = min(c, count);
			ndone += c;
			count -= c;
			c *= size;
			_move(ptr, iop->_ptr, c);
			ptr += c;
			iop->_ptr += c;
			iop->_cnt -= c;
		} else if(iop->_cnt > 0) { /* one the slow way to get new buffer */
			s = size;
			do {
				putc(*ptr++, iop);
			} while (--s);
			if(ferror(iop) == 0) {
				ndone++;
				count--;
			}
		}
	}
	return(ndone);
}
