/*
 * Return file offset.
 * Coordinates with buffering.
 */

#include <stdio.h>
#include <stdioerr.h>

int     seek();


int  ftell(iop)
FILE *iop;
{
	extern int errno;
	int  tres;
	register adjust;

	if (iop == NULL)
		return(_stdioerr(EFPNULL, "ftell"));
	if (iop->_flag&_IOMEM)
		return(_mftell(iop));
	if (iop->_cnt < 0)
		iop->_cnt = 0;
	if (iop->_flag&_IOREAD)
		adjust = - iop->_cnt;
	else if(iop->_flag&(_IOWRT|_IORW)) {
		adjust = 0;
		if (iop->_flag&_IOWRT && iop->_base && (iop->_flag&_IONBF)==0)
			adjust = iop->_ptr - iop->_base;
	} else
		return(-1);
	tres = seek(fileno(iop), 0, 1);
	if (tres < 0)
		return(_stdioerr(errno, "ftell", iop->_filename));
	tres += adjust;
	return(tres);
}
