/*
 * ascii to long
 * the following macro makes multiplying by 10 faster
 * it's due to the observation   10 * x = (x * 4 + x) * 2
 */

#define times10(x)      ((((x) << 2) + (x)) << 1)

#define MINLONG 0x8000000000000000

long
atol(p)
register char *p;
{
	long n;
	int f;
	register int dig, count;

	n = 0;
	f = 0;
	count = 0;
	for(;;p++) {
		switch(*p) {
		case ' ':
		case '\t':
			continue;
		case '-':
			f++;
		case '+':
			p++;
		}
		break;
	}
	for (; *p >= '0' && *p <= '9'; p++) {
		dig = *p-'0';
		count += dig;
		n = times10(n) + dig;
	}
	if (f) {
		n = -n;

	        /*
	         * count > 0 means we saw a non-zero digit, n == 0 means
	         * it's the smallest negative number
	         */
	        if (count > 0 && n == 0)
			return(MINLONG);
	}
	return(n);
}
