/*
 * p/n:
 * Program name:        Dump Formatter Hex/Ascii print routine
 * Author:              Ken Bowler
 * Backup:
 *
 * Description:
 * pdump dumps the bytes in storage on stdout in a nice format:
 *
 * xxxxxx  wwwwwwww wwwwwwww wwwwwwww wwwwwwww  cccccccccccccccc
 *
 *  Where: xxxxxxx     is the address f bytes being dumped
 *         wwwwwwww    is the hex representation of the bytes
 *         cccc ...    is the ascii representation of the bytes
 *                     in which unprintable characters are "."
 *                     Unprintable characters are defined as those
 *                     with a value less than 0x20. The high order
 *                     bit in the byte is turned off before printing
 *                     so that the byte is not construed by pr
 *                     etc. to have some special meaning.
 *
 *  The line represented above is for 16 bytes per line.
 *
 *  Duplicate lines are supressed,.
 *
 *  In general, 16 bytes per line is nice for terminals, and 32 bytes
 *  per line is nice for printers.
 */

#define WORDSIZE 4
#define PRINTABLE ' '
#include <stdio.h>
#include "dump.h"

extern  FILE     *out;

pdump(address, ptr, len, width)
int    address;      /* the address to prefix line with */
char   *ptr;         /* the pointer to the bytes to dump */
int    len;          /* number of bytes to dump */
int    width;        /* number of bytes to dump on 1 line */
{
        char *p,*ps;
        char ostring[130];
        int i,n,lentest,skip,pskip,loop;

        loop = 0;
        skip = 0;  /* no skipping first time */
        pskip = 0; /* we have not printed a skip line */

        while (len > 0){
                lentest = len;
                ps = ostring;
                p = ptr;
                for (i = 0; i < width; i++){
                        if (lentest > 0){
                                if ((loop !=0) && (*ps != *p))
                                        skip = 0;
                                *ps++ = *p++;
                        }
                        lentest -= 1;
                }
                if (skip == 0) {
                        p = ptr;
                        fprintf(out,"%6x  ",address);
                        for (i = 0; i < width; i += WORDSIZE) {
                                for (n = 0; n < WORDSIZE; n++) {
                                        if (len > 0)
                                                fprintf(out,"%2x",*p++);
                                        else
                                                fprintf(out,"  ");
                                        len--;
                                }
                                fprintf(out," ");
                        }
                        fprintf(out,"  ");
                        n = ps - ostring;
                        ps = ostring;
                        for (i=0; i < n; i++){
                                if ((*ps & 0177) < PRINTABLE)
                                        fprintf(out,".");
                                else
                                        fprintf(out,"%c", *ps & 0177);
                                *ps++;
                        }
                        fprintf(out,"\n");
                        pskip = 0;       /* reset printed skip line switch */
                        skip = 1;        /* assume next line will be the same */
                } else {
                        if (pskip == 0)
                                fprintf(out,"......  ...\n");
                        len -= width;
                        pskip = 1;      /* set printed skip line switch */
                }
                loop++;
                address += width;
                ptr += width;
        }
}
