/*
 *  Send message to given VM user
 *
 *  Synopsis: vmmsg userid [message ...]
 *
 *  If no message is given on the command line, the standard input
 *  is used.
 */
#include <stdio.h>
#include <ctype.h>
#include <pwd.h>

#define MAXLEN  130

extern  int errno;
char    mesg[512];
char    *getlogin();
struct  passwd *getpwuid();

main(argc, argv)  char *argv[];
{
	char    line[200];
        char    userid[40], *myid;
	int     rc;

	if (--argc < 1) {
		fprintf(stderr, "Usage: vmmsg userid [message ...]\n");
		exit(1);
	}
	myid = getlogin();
	if (myid == NULL) {
		struct passwd *pwent;
		pwent = getpwuid(getuid());
		if (pwent==NULL)
			myid = "???";
		else
			myid = pwent->pw_name;
	}
        sprintf(mesg, "M %s USER %s -->", *++argv, myid);
	strcpy(userid, *argv);
	if (--argc )
                /* Send the arguments */
		do {
			strcat(mesg, " ");
			strcat(mesg, *++argv);
		} while (--argc && strlen(mesg) < MAXLEN);
	else
                /* Use standard input */
		while (gets(line) != NULL && strlen(mesg) < MAXLEN) {
			strcat(mesg, " ");
			strcat(mesg, line);
		}
	mesg[MAXLEN] = NULL;   /* Be sure message not too long */
	upper_case(mesg);      /* and that it is upper case    */
	if ((rc = cpcmd(mesg)) != 0)
	switch(errno) {
		case 45:
			fprintf(stderr, "Userid %s not logged on.\n",
			        userid);
			break;
		case 57:
			fprintf(stderr, "Userid %s not receiving.\n",
			        userid);
			break;
		default:
			fprintf(stderr, "CP Message failed, R(%d)\n",
				errno);
			break;
	}
	exit(rc);
}


upper_case(s)  char *s;
{
	while (*s) {
		*s = islower(*s)? toupper(*s) : *s;
		s++;
	}
}
