/*
*  The 'tsoid' command takes no arguments, but writes the current
*  user's TSO userid (given in the fifth entry of the /etc/passwd
*  file) to the standard output.  A null value is returned if the
*  userid is invalid or missing.
*/

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <pwd.h>

struct passwd *pw;

main()
{
        int uid;
        char *s;

        uid = getuid();
        if ( (pw = getpwuid(uid)) == NULL) goto badid;
        s = pw->pw_tsoid;
        while(*s) {
                *s = islower(*s) ? toupper(*s) : *s;
                ++s;
        }
        puts(pw->pw_tsoid);
        exit(0);

badid:
	putchar('\n');
        exit(1);
}
