#include        <stdio.h>
#include        <signal.h>
#include	"defs.h"
#include	"sym.h"

int fault();
static char	quote;	/* used locally */
static char	quoted;	/* used locally */
static char     *bp;                    /* pointer within mbuf[] */
static char     mbuf[SHBUFSIZ];         /* buffer for macro() and */
					/* his children */

char     *
copyto(endch)
register int    endch;
{
	register int    c;

	while ((c = getch(endch)) != endch && c != EOF) {
		if (bp >= &mbuf[SHBUFSIZ])
			bufover();
		*bp++ = c | quote;
	}
	*bp = '\0';
	if (c != endch) {
		error(badsub);
	}
}

skipto(endch)
register int    endch;
{
	/* skip chars up to } */
	register int    c;
	while ((c=readc()) != EOF && c!=endch) {
		switch (c) {

		case SQUOTE:	
			skipto(SQUOTE); 
			break;

		case DQUOTE:	
			skipto(DQUOTE); 
			break;

		case DOLLAR:	     
			if (readc()==BRACE) {	
				skipto('}');
			}
		}
	}
	if (c!=endch) { 
		error(badsub);
	}
}

getch(endch)
register int     endch;
{
	register int    d;

retry:
	d = readc();
	if (!subchar(d)) {	
		return(d);
	}
	if (d == DOLLAR) {
		register int  c;
		if ((c = readc(), dolchar(c))) {
			register struct  namnod  *n = NULL;
			int     dolg = 0;
			char	bra;
			char    *v, *gbuf, *gp, *argp;
			char	idb[2];
			char    *id = idb;

			if (bra = (c == BRACE)) {
				c = readc();
			}
			if (letter(c)) {	
				gbuf = gp = malloc(SHBUFSIZ);
				while (alphanum(c)) { 
					*gp++= c;
					c = readc();
				}
				*gp = '\0';
				n = lookup(gbuf);
				v = n->namval; 
				id = n->namid;
				peekc = c|MARK;
				free(gbuf);
			} 
			else if (digchar(c)) {	
				*id = c;
				idb[1] = '\0';
				if (astchar(c)) {	
					dolg = 1;
					c = '1';
				}
				c -= '0';
                                if (c == 0)
                                        v = cmdadr;
                                else if (c <= dolc) {
                                        v = dolv[c];
				}
                                else {
                                        dolg = 0;
                                        v = NULL;
                                }
			} else switch(c) {
			/*
			 *  Special shell variables
			 */
			case '$':
				v = pidadr;
				break;
			case '!':
				v = pcsadr;
				break;
			case '#':
				v = dolladr;
				break;
			case '?':
				v = exitadr;
				break;
			case '-':
				v = flagadr;
				break;
			default:
				if (bra)
					error(badsub);
				else
					goto retry;
			}
			c = readc();
			if (!defchar(c) && bra) {	
				error(badsub);
			}
                        argp = NULL;
			if (bra) {	     
				if (c != '}') {
                                        argp = bp;
					if ((v == NULL) ^ (setchar(c) != 0)) {
						copyto('}');
					} else {
						skipto('}');
					}
				}
			} else {
				peekc = c|MARK; 
				c = 0;
			}
			if (v) {	     
				if (c != '+') {
					for (;;) {   
						while (c = *v++) { 
                                                        if (bp >= &mbuf[SHBUFSIZ])
                                                                bufover();
							*bp++ = c | quote;
						}
						if (dolg == 0 || (++dolg > dolc)) {
							break;
						} 
						else { 
							v = dolv[dolg];
							*bp++ = (SP|(*id=='*' ? quote : 0));
						}
					}
				}
			} 
			else if (argp) {
				if (c == '?') {
					failed(id, (*argp)? argp: badparam);
				} 
				else if (c == '=') {
					if (n) {	
						assign(n, argp);
					} else {
						error(badsub);
					}
				}
			} 
			else if (flags & SETFLG) {
				failed(id, badparam);
			}
			goto retry;
		} 
		else {	
			peekc=c|MARK;
		}
	} 
	else if (d == endch) {
		return(d);
	} 
	else if (d == SQUOTE) {
		comsubst();
		goto retry;
	} 
	else if (d == DQUOTE) {
		quoted++; 
		quote ^= QUOTE;
		goto retry;
	}
	return(d);
}

char	*macro(as)
register char	*as;
{
	/*
	 * Strip "" and do $ substitution
         */
	register char	savqu =quoted;
	register char	savq = quote;
	register char    *s;
	int     svflg;
	char    *svptr;

	svflg = cflg;
	svptr = cptr;
	cflg = 1;
	cptr = as;

	quote = 0;
	quoted = 0;
	bp = mbuf;
        copyto(EOF);
	cflg = svflg;
	cptr = svptr;
	if (quoted && (bp == mbuf)) {
		*bp++ = QUOTE;
		*bp = '\0';
	}
	quote = savq;
	quoted = savqu;
	s = malloc(strlen(mbuf) + 1);
	strcpy(s, mbuf);
	return(s);
}


comsubst()
{
	/* command substn */
	register int    d;
	register int     svflg, svflin;
	char    *svptr;
	FILE    *svfp;
	char    *svbp = bp;

	while ((d = readc()) != SQUOTE && d != EOF) {
		*bp++ = d;
	}

        *bp = '\0';
        trim(svbp);
        svflg = cflg;
        svptr = cptr;
        cflg = 1;
        cptr = svbp;
	{
		register union  node  *t = makefork(FPOU, cmd(EOFSYM, MTFLG|NLFLG));
		int  pv[2];
		/*
		 * this is done like this so that the pipe
                 * is open only when needed
                 */
		cflg = svflg;
		cptr = svptr;

		chkpipe(pv);

		svflg = cflg;
		svfp = cfp;
		svflin = flin;
		cflg = 0;
		cfp = fdopen(pv[INPIPE], "r");
		isapipe(pv[INPIPE]);
		execute(t, 0, 0, pv);
		fclose(fdopen(pv[OTPIPE], "w"));
	}
	bp = svbp;
	while ((d = readc()) != EOF) {
		if (bp >= &mbuf[SHBUFSIZ]) {
			while (readc() != EOF)
				;
			fclose(cfp);
                        cfp = svfp;
			flin = svflin;
			bufover();
		}
		*bp++ = d | quote;
        }
	await(0);
	while (bp != svbp) {
		if ((*--bp & STRIP) != NL) {
			bp++;
			break;
		}
	}
	*bp = '\0';
	fclose(cfp);
	cfp = svfp;
	cflg = svflg;
        flin = svflin;
}

subst(ifp, ofp)
register FILE    *ifp;
register FILE    *ofp;
{
	register int   c;
	int     svflg;
	FILE    *svfp;

	svflg = cflg;
	svfp = cfp;
	cflg = 0;
	cfp = ifp;
	bp = mbuf;
	/* DQUOTE used to stop it from quoting */
	while ((c = getch(DQUOTE)) != EOF) {
		if (bp >= &mbuf[SHBUFSIZ])
			bufover();
		*bp++ = c & STRIP;
		if (c == NL) {
			*bp = '\0';
			fprintf(ofp, "%s", mbuf);
		bp = mbuf;
		}
	}
	cflg = svflg;
	cfp = svfp;
}
