#include        <stdio.h>
#include	"defs.h"


/* ========	error handling	======== */

exitset()
{
	assnum(&exitadr, exitval);
}

sigchk()
{
	/* Find out if it is time to go away.
         * `trapnote' is set to SIGSET when fault is seen and
         * no trap has been set.
         */
	if (trapnote&SIGSET) {
		exitsh(SIGFAIL);
	}
}

failed(s1, s2)
register char	*s1, *s2;
{
	prp(); 
	fprintf(stderr, "%s: %s\n", s1, (s2 != NULL)? s2: "");
	exitsh(ERROR);
}

error(s)
register char	*s;
{
	failed(s, (char *) NULL);
}

exitsh(xno)
register int	xno;
{
	/* Arrive here from `FATAL' errors
         *  a) exit command, 
         *  b) default trap, 
         *  c) fault with no trap set.
         *
	 * Action is to return to command level or exit.
         */
	exitval = xno;
	if ( (flags & (FORKED|ERRFLG|TTYFLG)) != TTYFLG) {
		done();
	} 
	else {	
		clearup();
		longjmp(errshell, 1);
	}
}

done()
{
	register char	*t;

	if (t = trapcom[0]) {
		trapcom[0] = NULL;
		execexp(t, (FILE *) NULL);
	}
	exit(exitval);
}

bufover()
{

	prp();
	fprintf(stderr, "%s", boverflw);
	fprintf(stderr, "%s", stringlong);
	if (flags & PROMPT)
                longjmp(errshell, 0);
        exitsh(ERROR);
}
