/*
 *    Qume--Sprint 5 --- simulator for 3270 terminals
 */

#define PITCH 12
#include "Struct.h"

	0,           /* bset      */
	0,           /* breset    */
	INCH/120,    /* Hor       */
	INCH/48,     /* Vert      */
	INCH/6,      /* Newline   */
	INCH/PITCH,  /* Char      */
	INCH/PITCH,  /* Em        */
	INCH/12,     /* Halfline  */
	INCH/PITCH,  /* Adj       */

	"",          /* twinit    --  at start of file               */
	"",          /* twrest    --  to reset printer               */
	"\012",      /* twnl      -- LF becomes CR LF                */
	"\033D",     /* hlr       -- ESC D, negative half line feed  */
	"\033U",     /* hlf       -- ESC U, positive half line feed  */
	"\033\013",  /* flr       -- ESC VT becomes ESC LF           */
	"\016",      /* bdon      -- SO, bold font on                */
	"\017",      /* bdoff     -- SI, bold font off               */
	"\033G",     /* ploton    -- ESC G, graphics on              */
	"\0334",     /* plotoff   -- ESC 4, graphics off             */
	"\033\013",  /* up        -- ESC VT becomes ESC LF           */
	"\013",      /* down      -- VT becomes LF                   */
	"\040",      /* right     -- SP, space                       */
	"\010",      /* left      -- BS, back space                  */
#define Q3270
#include "Normal"
	"\000",         /* narrow space */
	"\201-",        /* hyphen */
	"\201*",        /* bullet */
	"\201#",        /* square */
	"\202--",       /* 3/4 em dash -- */
	"\201_",        /* rule */
	"\20214",       /* 1/4 */
	"\20212",       /* 1/2 */
	"\20234",       /* 3/4 */
	"\201-",        /* \- */
	"\202fi",       /* fi */
	"\202fl",       /* fl */
	"\202ff",       /* ff */
	"\203ffi",      /* ffi */
	"\203ffl",      /* ffl */
	"\201o",        /* degree */
	"\201-\b|",     /* dagger */
	"\201#",        /* section */
	"\201'",        /* foot mark */
	"\201'",        /* acute accent */
	"\201`",        /* grave accent */
	"\201_",        /* underrule, \_ */
	"\201/",        /* slash (longer) */
	"\000",         /* half narrow space */
	"\001 ",        /* unpaddable space */
	"\201a",        /* alpha */
	"\201b",        /* beta */
	"\201g",        /* gamma */
	"\201d",        /* delta */
	"\201e",        /* epsilon */
	"\201z",        /* zeta */
	"\201y",        /* eta */
	"\201h",        /* theta */
	"\201i",        /* iota */
	"\201k",        /* kappa */
	"\201l",        /* lambda */
	"\201m",        /* mu */
	"\201n",        /* nu */
	"\201c",        /* xi */
	"\201o",        /* omicron */
	"\201p",        /* pi */
	"\201r",        /* rho */
	"\201s",        /* sigma */
	"\201t",        /* tau */
	"\201u",        /* upsilon */
	"\201f",        /* phi */
	"\201x",        /* chi */
	"\201q",        /* psi */
	"\201w",        /* omega */
	"\201G",        /* Gamma */
	"\201D",        /* Delta */
	"\201H",        /* Theta */
	"\201L",        /* Lambda */
	"\201C",        /* Xi */
	"\201P",        /* Pi */
	"\201S",        /* Sigma */
	"\201\"",       /* " */
	"\201U",        /* Upsilon */
	"\201F",        /* Phi */
	"\201Q",        /* Psi */
	"\201W",        /* Omega */
	"\201+",        /* square root, check mark */
	"\201S",        /* terminal sigma */
	"\201_",        /* root en */
	"\201_\b>",     /* >= */
	"\201_\b<",     /* <= */
	"\201_\b=",     /* identically equal */
	"\201-",        /* equation minus */
	"\201-\b~",     /* approx = */
	"\201~",        /* approximates */
	"\201!",        /* not equal */
	"\202->",       /* right arrow */
	"\202<-",       /* left arrow */
	"\201T",        /* up arrow */
	"\201v",        /* down arrow */
	"\201=",        /* equation equal */
	"\201x",        /* multiply */
	"\201/",        /* divide */
	"\201_\b+",     /* plus-minus */
	"\201u",        /* cup (union) */
	"\201n",        /* cap (intersection) */
	"\201 ",        /* subset of */
	"\201 ",        /* superset of */
	"\201 ",        /* improper subset */
	"\201 ",        /* improper superset */
	"\202oo",       /* infinity */
	"\201 ",        /* partial derivative */
	"\201 ",        /* gradient */
	"\201~",        /* not */
	"\201 ",        /* integral sign */
	"\201 ",        /* proportional to */
	"\201/\b0",     /* empty set */
	"\201 ",        /* member of */
	"\201+",        /* equation plus */
	"\202rg",       /* registered */
	"\202co",       /* copyright */
	"\201|",        /* alternate vertical rule  */
	"\201\\",       /* cent sign */
	"\201=\b|",     /* double dagger */
	"\202=>",       /* right hand */
	"\202<=",       /* left hand */
	"\201*",        /* math * */
	"\000\007",     /* bell signal */
	"\201|",        /* or */
	"\201O",        /* circle */
	"\201|",        /* big brace left top     */
	"\201|",        /* big brace left bottom  */
	"\201|",        /* big brace right top    */
	"\201|",        /* big brace right bottom */
	"\201<",        /* big brace left center  */
	"\201>",        /* big brace right center */
	"\201|",        /* box vertical rule        */
	"\201|",        /* box corner left  floor   */
	"\201|",        /* box corner right floor   */
	"\201|",        /* box corner left  ceiling */
	"\201|",        /* box corner right ceiling */
	"\201#",        /* solid square */
	"\202. ",       /* for lines of ". . . . . " */
	"\202TM",       /* trademark */
	"\000",         /* shift up */
	"\000",         /* shift down */
	0
};
