/*
 * Update group information.
 * this program should be suid with owner
 * with an owner with write permission on /etc/group
 */
#include <stdio.h>
#include <signal.h>
#include <grp.h>
#include <pwd.h>

#define max(a, b) (a > b ? a : b)

char    group[] = "/etc/group";
char    temp[]  = "/etc/gtmp";
struct  group *getgrent();
struct  passwd *getpwnam();
int     endgrent();
char	*strcpy();
char	*crypt();
char	*getpass();
char	*getlogin();
char    buf[BUFSIZ];
int     list, show, join, quit, create, delete, add, remove, purge;
int     root;
FILE    *tf;

main(argc, argv)
char *argv[];
{
	int salt, i, c, fi, fo, u;
	char saltc[2];
	char **ulist, *grpname, **n, *nm;
	char **plist;
	int ucnt, pcnt;
	int maxgid = -1;
	struct group *gr, cgrp;

	if(argc < 3 && argv[1][0] != 's')
		usage();
	switch(argv[1][0]) {
	case 'l':
                list++;
                break;
	case 's':
                show++;
                break;
	case 'j':
                join++;
                break;
	case 'q':
                quit++;
                break;
	case 'c':
                create++;
                break;
	case 'd':
                delete++;
                break;
	case 'a':
                add++;
                break;
	case 'r':
                remove++;
                break;
	case 'p':
                purge++;
                break;
	default:
                usage();
                break;
	}

	if (show) {
		grpname = "XXX";
                ulist = &argv[3];
                ucnt = argc - 3;
	} else if (purge) {
		grpname = "XXX";
                ulist = &argv[2];
                ucnt = argc - 2;
	} else {
		grpname = argv[2];
                ulist = &argv[3];
                ucnt = argc - 3;
	}

	root = (getuid() == 0);

	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);

	if(access(temp, 0) >= 0) {
		printf("Temporary file busy -- try again\n");
		exit(1);
	}
	close(creat(temp,0600));
	if((tf=fopen(temp,"w")) == NULL) {
		error("Cannot create temporary file\n");
	}

        /*
         *      copy group to temp, replacing matching lines
         *      with new info.
         */
	while((gr = getgrent()) != NULL) {
		if(strcmp(gr->gr_name, grpname) == 0) {
			if(create)
				error("Group %s already exists.\n", grpname);
			if(gr->gr_passwd[0] == 0 && (!root) && (delete||add||remove))
				error("Invalid request for public group.\n");
			if(gr->gr_passwd[0] != 0 && !(root||quit||list))
				if(strcmp(gr->gr_passwd, crypt(getpass("Password:"), gr->gr_passwd)))
					error("Sorry.\n");
			if(join) {
				dojoin(gr, getlogin());
				join = 0;
			}
			if(quit) {
				doquit(gr, getlogin());
				quit = 0;
			}
			if(add) {
				while(ucnt--) dojoin(gr, *ulist++);
				add = 0;
			}
			if(remove) {
				while(ucnt--) doquit(gr, *ulist++);
				remove = 0;
			}
			if(delete) {
				while(*gr->gr_mem) doquit(gr, *gr->gr_mem);
				delete = 0;
                                continue;
			}
			if(list) {
				for(n = gr->gr_mem; *n != NULL; n++)
					printf("%s\n", *n);
				list = 0;
			}
		}
		if (purge) {
			plist = ulist;
			pcnt = ucnt;
			while (pcnt--)
				dopurge(gr, *plist++);
		}
		if(show) {
			nm = getlogin();
			for(n = gr->gr_mem; *n != NULL; n++)
				if(strcmp(*n, nm) == 0)
					printf("%s\n", gr->gr_name);
		}
                putgrent(gr);
		maxgid = max(maxgid, gr->gr_gid);
	}
	if(list||join||quit||delete||add||remove)
		error("Group %s does not exist.\n", grpname);
	if(create) {
		gr = &cgrp;
		gr->gr_name = grpname;
		gr->gr_passwd = getpass("Password:");
		if(gr->gr_passwd[0] != 0) {
                        salt = time();
                        salt += getpid();
                        saltc[0] = salt & 077;
                        saltc[1] = (salt>>6) & 077;
                        for(i=0;i<2;i++){
                                c = saltc[i] + '.';
                                if(c>'9') c += 7;
                                if(c>'Z') c += 6;
                                saltc[i] = c;
                        }
			gr->gr_passwd = crypt(gr->gr_passwd, saltc);
		}
		gr->gr_gid = maxgid+1;
		gr->gr_mem = ulist;
		putgrent(gr);
	}

	fclose(tf);

        /*
         *      copy temp back to group file
         */

	if((fi=open(temp,0)) < 0)
		error("Temp file disappeared!\n");
	if((fo=creat(group, 0644)) < 0)
		error("Cannot recreat passwd file.\n");
	while((u=read(fi,buf,sizeof(buf))) > 0) write(fo,buf,u);

	unlink(temp);
	exit(0);
}

dojoin(gr, nm)
struct group *gr;
char *nm;
{
	char **n;

	for(n = gr->gr_mem; *n != NULL; n++)
		if(strcmp(*n, nm) == 0)
			error("User %s is already in group %s.\n", nm, gr->gr_name);
	*n++ = nm;
	*n = NULL;
}

doquit(gr, nm)
struct group *gr;
char *nm;
{
	struct passwd *pw;
	char **p, **q;

	pw = getpwnam(nm);
	if(pw != NULL && pw->pw_gid == gr->gr_gid)
		error("Can't remove %s from login group %s.\n", nm, gr->gr_name);
	for(p = gr->gr_mem, q = gr->gr_mem; *p != NULL; p++)
		if(strcmp(*p, nm) != 0)
			*q++ = *p;
	if(q == p)
		error("User %s not in group %s.\n", nm, gr->gr_name);
	*q = NULL;
}

dopurge(gr, nm)
struct group *gr;
char *nm;
{
	char **p, **q;

	if (!root)
		error("only super-user may purge someone\n");
	for(p = gr->gr_mem, q = gr->gr_mem; *p != NULL; p++) {
		if(strcmp(*p, nm) != 0)
			*q++ = *p;
	}
	*q = NULL;
}

putgrent(gr)
struct group *gr;
{
	char **n;

	fprintf(tf, "%s:%s:%d:", gr->gr_name, gr->gr_passwd, gr->gr_gid);
	for(n = gr->gr_mem; *n != NULL; n++) {
		if(n != gr->gr_mem) putc(',', tf);
		fprintf(tf, "%s", *n);
	}
	putc('\n', tf);
}

usage()
{
	fprintf(stderr, "Usage: group  list  grpname\n");
	fprintf(stderr, "       group  show\n");
	fprintf(stderr, "       group  join  grpname\n");
	fprintf(stderr, "       group  quit  grpname\n");
	fprintf(stderr, "       group create grpname user ...\n");
	fprintf(stderr, "       group delete grpname\n");
	fprintf(stderr, "       group  add   grpname user ...\n");
	fprintf(stderr, "       group remove grpname user ...\n");
	fprintf(stderr, "       group purge  user ...\n");
	exit(1);
}

/*VARARGS*/
error(s)
char *s;
{
	printf("%r", &s);
	unlink(temp);
	exit(1);
}
