/*
 * 470 opcodes, by color
 */

struct optab op[NUMOPS]{
	0x04,	"spm",	RR,
	0x05,	"balr",	RR,
	0x06,	"bctr",	RR,
	0x07,	"bcr",	BRANCHR,
	0x08,	"ssk",	RR,
	0x09,	"isk",	RR,
	0x0a,	"svc",	RR,
	0x0e,	"mvcl",	RR,
	0x0f,	"clcl",	RR,
	0x10,	"lpr",	RR,
	0x11,	"lnr",	RR,
	0x12,	"ltr",	RR,
	0x13,	"lcr",	RR,
	0x14,	"nr",	RR,
	0x15,	"clr",	RR,
	0x16,	"or",	RR,
	0x17,	"xr",	RR,
	0x18,	"lr",	RR,
	0x19,	"cr",	RR,
	0x1a,	"ar",	RR,
	0x1b,	"sr",	RR,
	0x1c,	"mr",	RR,
	0x1d,	"dr",	RR,
	0x1e,	"alr",	RR,
	0x1f,	"slr",	RR,
	0x20,	"lpdr",	RR,
	0x21,	"lndr",	RR,
	0x22,	"ltdr",	RR,
	0x23,	"lcdr",	RR,
	0x24,	"hdr",	RR,
	0x25,	"lrdr",	RR,
	0x26,	"mxr",	RR,
	0x27,	"mxdr",	RR,
	0x28,	"ldr",	RR,
	0x29,	"cdr",	RR,
	0x2a,	"adr",	RR,
	0x2b,	"sdr",	RR,
	0x2c,	"mdr",	RR,
	0x2d,	"ddr",	RR,
	0x2e,	"awr",	RR,
	0x2f,	"swr",	RR,
	0x30,	"lper",	RR,
	0x31,	"lner",	RR,
	0x32,	"lter",	RR,
	0x33,	"lcer",	RR,
	0x34,	"her",	RR,
	0x35,	"lrer",	RR,
	0x36,	"axr",	RR,
	0x37,	"sxr",	RR,
	0x38,	"ler",	RR,
	0x39,	"cer",	RR,
	0x3a,	"aer",	RR,
	0x3b,	"ser",	RR,
	0x3c,	"mer",	RR,
	0x3d,	"der",	RR,
	0x3e,	"aur",	RR,
	0x3f,	"sur",	RR,
	0x40,	"sth",	RX,
	0x41,	"la",	RX,
	0x42,	"stc",	RX,
	0x43,	"ic",	RX,
	0x44,	"ex",	RX,
	0x45,	"bal",	RX,
	0x46,	"bct",	RX,
	0x47,	"bc",	BRANCH,
	0x48,	"lh",	RX,
	0x49,	"ch",	RX,
	0x4a,	"ah",	RX,
	0x4b,	"sh",	RX,
	0x4c,	"mh",	RX,
	0x4e,	"cvd",	RX,
	0x4f,	"cvb",	RX,
	0x50,	"st",	RX,
	0x54,	"n",	RX,
	0x55,	"cl",	RX,
	0x56,	"o",	RX,
	0x57,	"x",	RX,
	0x58,	"l",	RX,
	0x59,	"c",	RX,
	0x5a,	"a",	RX,
	0x5b,	"s",	RX,
	0x5c,	"m",	RX,
	0x5d,	"d",	RX,
	0x5e,	"al",	RX,
	0x5f,	"sl",	RX,
	0x60,	"std",	RX,
	0x67,	"mxd",	RX,
	0x68,	"ld",	RX,
	0x69,	"cd",	RX,
	0x6a,	"ad",	RX,
	0x6b,	"sd",	RX,
	0x6c,	"md",	RX,
	0x6d,	"dd",	RX,
	0x6e,	"aw",	RX,
	0x6f,	"sw",	RX,
	0x70,	"ste",	RX,
	0x78,	"le",	RX,
	0x79,	"ce",	RX,
	0x7a,	"ae",	RX,
	0x7b,	"se",	RX,
	0x7c,	"me",	RX,
	0x7d,	"de",	RX,
	0x7e,	"au",	RX,
	0x7f,	"su",	RX,
	0x80,	"ssm",	SI2,
	0x82,	"lpsw",	SI2,
	0x83,	"diag",	RS1,
	0x84,	"wrd",	SI1,
	0x85,	"rdd",	SI1,
	0x86,	"bxh",	RS1,
	0x87,	"bxle",	RS1,
	0x88,	"srl",	RS2,
	0x89,	"sll",	RS2,
	0x8a,	"sra",	RS2,
	0x8b,	"sla",	RS2,
	0x8c,	"srdl",	RS2,
	0x8d,	"sldl",	RS2,
	0x8e,	"srda",	RS2,
	0x8f,	"slda",	RS2,
	0x90,	"stm",	RS1,
	0x91,	"tm",	SI1,
	0x92,	"mvi",	SI1,
	0x93,	"ts",	SI2,
	0x94,	"ni",	SI1,
	0x95,	"cli",	SI1,
	0x96,	"oi",	SI1,
	0x97,	"xi",	SI1,
	0x98,	"lm",	RS1,
	0x9d,	"tio",	SI2,
	0x9f,	"tch",	SI2,
	0xac,	"stnsm",SI1,
	0xad,	"stosm",SI1,
	0xae,	"sigp",	RS1,
	0xaf,	"mc",	SI1,
	0xb1,	"lra",	RX,
	0xb6,	"stctl",RS1,
	0xb7,	"lctl",	RS1,
	0xba,	"cs",	RS1,
	0xbb,	"cds",	RS1,
	0xbd,	"clm",	RS1,
	0xbe,	"stcm",	RS1,
	0xbf,	"icm",	RS1,
	0xd1,	"mvn",	SS2,
	0xd2,	"mvc",	SS2,
	0xd3,	"mvz",	SS2,
	0xd4,	"nc",	SS2,
	0xd5,	"clc",	SS2,
	0xd6,	"oc",	SS2,
	0xd7,	"xc",	SS2,
	0xdc,	"tr",	SS2,
	0xdd,	"trt",	SS2,
	0xde,	"ed",	SS2,
	0xdf,	"edmk",	SS2,
	0xf0,	"srp",	SS3,
	0xf1,	"mvo",	SS1,
	0xf2,	"pack",	SS1,
	0xf3,	"unpk",	SS1,
	0xf8,	"zap",	SS1,
	0xf9,	"cp",	SS1,
	0xfa,	"ap",	SS1,
	0xfb,	"sp",	SS1,
	0xfc,	"mp",	SS1,
	0xfd,	"dp",	SS1,
	0x9c00,	"sio",	S,
	0x9c01,	"siof",	S,
	0x9d01,	"clrio",S,
	0x9e00,	"hio",	S,
	0x9e01,	"hdv",	S,
	0xb202,	"stidp",S,
	0xb203,	"stidc",S,
	0xb204,	"sck",	S,
	0xb205,	"stck",	S,
	0xb206,	"sckc",	S,
	0xb207,	"stckc",S,
	0xb208,	"spt",	S,
	0xb209,	"stpt",	S,
	0xb20a,	"spka",	S,
	0xb20b,	"ipk",	S,
	0xb20d,	"ptlb",	S,
	0xb210,	"spx",	S,
	0xb211,	"stpx",	S,
	0xb212,	"stap",	S,
	0xb213,	"rrb",	S,
	};
	
struct systab sys[NUMSYS]{
	1,	"exit",
	2,	"fork",
	3,	"read",
	4,	"write",
	5,	"open",
	6,	"close",
	7,	"wait",
	8,	"creat",
	9,	"link",
	10,	"unlink",
	11,	"exec",
	12,	"chdir",
	13,	"time",
	14,	"mknod",
	15,	"chmod",
	16,	"chown",
	17,	"break",
	18,	"stat",
	19,	"seek",
	20,	"getpid",
	21,	"mount",
	22,	"umount",
	23,	"setuid",
	24,	"getuid",
	25,	"stime",
	26,	"ptrace",
	28,	"fstat",
	30,	"smdate",
	31,	"stty",
	32,	"gtty",
	33,	"access",
	34,	"nice",
	35,	"sleep",
	36,	"sync",
	37,	"kill",
	38,	"switch",
	41,	"dup",
	42,	"pipe",
	43,	"times",
	44,	"prof",
	46,	"setgid",
	47,	"getgid",
	48,	"sig",
	49,	"rsig",
	50,	"tell",
	62,	"sysaddr",
	63,	"cpcmd",
	};

struct optab br[NUMBRS]{
	1,	"bo",	BRANCH,
	1,	"bor",	BRANCHR,
	2,	"bh",	BRANCH,
	2,	"bhr",	BRANCHR,
	2,	"bp",	BRANCH,
	2,	"bpr",	BRANCHR,
	4,	"bl",	BRANCH,
	4,	"blr",	BRANCHR,
	4,	"bm",	BRANCH,
	4,	"bmr",	BRANCHR,
	7,	"bne",	BRANCH,
	7,	"bner",	BRANCHR,
	7,	"bnz",	BRANCH,
	7,	"bnzr",	BRANCHR,
	8,	"be",	BRANCH,
	8,	"ber",	BRANCHR,
	8,	"bz",	BRANCH,
	8,	"bzr",	BRANCHR,
	11,	"bnl",	BRANCH,
	11,	"bnlr",	BRANCHR,
	11,	"bnm",	BRANCH,
	11,	"bnmr",	BRANCHR,
	13,	"bnh",	BRANCH,
	13,	"bnhr",	BRANCHR,
	13,	"bnp",	BRANCH,
	13,	"bnpr",	BRANCHR,
	14,	"bno",	BRANCH,
	14,	"bnor",	BRANCHR,
	15,	"b",	BRANCH,
	15,	"br",	BRANCHR,
	};
