/*
 * archive
 *
 * archive [-rip] filename...
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <pwd.h>

#define BLKSZE 4096

/*
 *  comment structure for information associated with an archived file
 */
struct  comment {
	struct  comment *c_next;        /* next comment line */
	char    *c_text;                /* a line of comment text */
};

struct stat statarea;

char *today = "/usr/spool/arch/.today";
char *base  = "/usr/spool/arch/";
char pwd[4096];
char callit[16];
char fullit[80];
char hold[BLKSZE];
extern char *cmdname;

main(argc, argv)
int argc;
char *argv[];
{
	FILE *popen();
	FILE *fpin;
	FILE *fpout;
	FILE *fptoday;
	FILE *fppwd;
	char *index();
	char *itts();
	char **files;
	int  rflag = 0;
	int  iflag = 0;
	int  aflag = 0;
	int  pflag = 0;
	int  sure  = 0;
	int  mode;
	int  atime;
	int  mtime;
	int  ctime;
	int  i;

	while (**++argv == '-') {
                argc--;
		while (*++*argv) {
                        switch(**argv) {
                        case 'r':
                                rflag++;
                                break;
                        case 'p':
                                pflag++;
                                break;
                        case 'i':
                                iflag++;
                                break;
                        case 'a':
                                aflag++;
                                break;
                        default:
                                fprintf(stderr, "%s: unknown flag %s\n", cmdname, *argv);
                                exit(1);
                        }
		}
        }
	if (argc <= 1) {
		fprintf(stderr, "%s: no files given\n", cmdname);
		exit(2);
	}
	files = argv;
        fptoday = fopen(today, "a");
        if (fptoday == NULL) {
                fprintf(stderr, "%s: cannot open today file\n", cmdname);
                exit(5);
        }
	/*
	 *  Get the current directory
	 */
        fppwd = popen("/bin/pwd", "r");
        if (fppwd == NULL) {
                fprintf(stderr, "%s: cannot obtain current directory\n", cmdname);
                exit(6);
        }
        fgets(pwd, 4096, fppwd);
        *index(pwd, '\n') = 0;
        pclose(fppwd);
        strcat(pwd, "/");
	while (--argc) {
		fpin = fopen(*argv, "r");
		if (fpin == NULL) {
			fprintf(stderr, "%s: cannot open %s\n", cmdname, *argv);
			continue;
		}
		stat(*argv, &statarea);
		mode = statarea.st_mode & 0777;
		if (pflag)
			mode &= ~07;
		atime = statarea.st_atime;
		mtime = statarea.st_mtime;
		ctime = time();
                sprintf(callit, "a%s", itts(ctime));
		strcat(callit, itts(getpid()));
		strcat(callit, itts(sure++));
		sprintf(fullit, "%s/%s", base, callit);
		fpout = fopen(fullit, "w");
		if (fpout == NULL) {
			fprintf(stderr, "%s: cannot open holding file\n", cmdname);
			exit(4);
		}
                while ((i=fread(hold, 1, BLKSZE, fpin)) == BLKSZE)
                        fwrite(hold, 1, BLKSZE, fpout);
                if (i != 0)
                        fwrite(hold, 1, i, fpout);
                fclose(fpin);
                fclose(fpout);
                totoday(*argv, callit, mode, atime, mtime, ctime, iflag, fptoday);
		if (aflag)
			printf("%s\n", callit);
		argv++;
        }
	fclose(fptoday);
	if (rflag) {
		setuid(getuid());
		while (*files != NULL) {
			unlink(*files);
			files++;
		}
	}
}


/*
 * Write info into .today file
 */
totoday(real, alias, mode, atime, mtime, ctime, moreinfo, fp)
char *real;
char *alias;
int  mode;
int  atime;
int  mtime;
int  ctime;
int  moreinfo;
FILE *fp;
{
	struct  passwd *getpwuid();
	struct  passwd *pwuid;
        char    use[256];

        if (*real == '/')
                sprintf(use, "%s", real);
        else
                sprintf(use, "%s%s", pwd, real);
        fprintf(fp, "%c%s %s", 07, use, alias);

	if ((pwuid = getpwuid(getuid())) == NULL)
		fprintf(fp, " ?");
	else
		fprintf(fp, " %s", pwuid->pw_name);

	fprintf(fp, " %03o %d %d %d\n", mode, ctime, atime, mtime);
	if (moreinfo)
		getinfo(fp);
	return;
}

/*
 * getinfo - get info
 * If requested, get more information for this archival.
 * Read comments from the standard input and save them in case
 * there are multiple files.
 */
getinfo(fp)
FILE    *fp;
{
	char    buff[512];
	char    *malloc(), *getenv();
	char    *ps2;
	struct  comment *c, **ptr;
	static  struct  comment *cmthdr = NULL;
	static  int     first = 1;

	if (first) {
		first = 0;
                if ((ps2 = getenv("PS2")) == NULL)
                        ps2 = "> ";
		if (isatty(fileno(stdin)))
                        printf("information:\n%s", ps2);
		ptr = &cmthdr;
                while (fgets(buff, sizeof(buff), stdin) != NULL &&
                       strcmp(buff, ".\n") != 0 &&
                       strcmp(buff, "\n") != 0) {
			c = (struct comment *) malloc(sizeof(struct comment));
                        c->c_next = NULL;
			c->c_text = malloc(strlen(buff)+1);
			strcpy(c->c_text, buff);
			*ptr = c;
			ptr = &c->c_next;
                        if (isatty(fileno(stdin)))
                                printf("%s", ps2);
		}
	}
	for (c = cmthdr; c != NULL; c = c->c_next)
                fprintf(fp, "%s", c->c_text);
}

/*
 * convert integer to base 26 (a-z) number
 */
char *itts(nn)
int nn;
{
	static char back[80];
	char *s;
	unsigned int digit = 1;
	unsigned int n;

	n = nn;
	s = back;
	while ((digit * 26) < n)
		digit *= 26;
	while (digit) {
		*s++ = 'a' + (n / digit);
		n %= digit;
		digit /= 26;
	}
	*s = 0;
	return(back);
}
